/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.xml.XMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.HtmlPageRenders;
import org.zkoss.zul.impl.XulElement;

public class Label
extends XulElement
implements org.zkoss.zul.api.Label {
    private String _value = "";
    private int _maxlength;
    private boolean _multiline;
    private boolean _pre;

    public Label() {
    }

    public Label(String value) {
        this.setValue(value);
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        if (!Objects.equals((Object)this._value, (Object)value)) {
            this._value = value;
            this.smartUpdate("value", this._value);
        }
    }

    public int getMaxlength() {
        return this._maxlength;
    }

    public void setMaxlength(int maxlength) {
        if (maxlength < 0) {
            maxlength = 0;
        }
        if (this._maxlength != maxlength) {
            this._maxlength = maxlength;
            this.smartUpdate("maxlength", this._maxlength);
        }
    }

    public boolean isMultiline() {
        return this._multiline;
    }

    public void setMultiline(boolean multiline) {
        if (this._multiline != multiline) {
            this._multiline = multiline;
            this.smartUpdate("multiline", this._multiline);
        }
    }

    public boolean isPre() {
        return this._pre;
    }

    public void setPre(boolean pre) {
        if (this._pre != pre) {
            this._pre = pre;
            this.smartUpdate("pre", this._pre);
        }
    }

    public boolean isHyphen() {
        return false;
    }

    public void setHyphen(boolean hyphen) {
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private static boolean isRawLabel(Component comp) {
        LanguageDefinition langdef = comp.getDefinition().getLanguageDefinition();
        return langdef != null && langdef.isRawLabel();
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._maxlength > 0) {
            renderer.render("maxlength", this._maxlength);
        }
        this.render(renderer, "multiline", this._multiline);
        this.render(renderer, "pre", this._pre);
        if (this._value.length() > 0) {
            boolean outed = false;
            HtmlPageRenders.RenderContext rc = HtmlPageRenders.getRenderContext(null);
            if (rc != null && rc.crawlable) {
                rc.extra.write("<div id=\"");
                rc.extra.write(this.getUuid());
                rc.extra.write("\">");
                rc.extra.write(XMLs.encodeText((String)this._value));
                rc.extra.write("</div>\n");
                outed = true;
            }
            if (outed) {
                renderer.render("z_ea", "$value");
            } else {
                this.render(renderer, "value", this._value);
            }
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-label" : this._zclass;
    }

    protected boolean isChildable() {
        return false;
    }
}

