/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.zkoss.util.Dates;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.SimpleDateConstraint;
import org.zkoss.zul.impl.FormatInputElement;
import org.zkoss.zul.mesg.MZul;

public class Datebox
extends FormatInputElement
implements org.zkoss.zul.api.Datebox {
    private TimeZone _tzone;
    private boolean _btnVisible = true;
    private boolean _lenient = true;
    private boolean _open = false;

    public Datebox() {
        this.setFormat(this.getDefaultFormat());
        this.setCols(11);
    }

    public Datebox(Date date) throws WrongValueException {
        this();
        this.setValue(date);
    }

    protected String getDefaultFormat() {
        String fmt;
        DateFormat df = DateFormat.getDateInstance(2, Locales.getCurrent());
        if (df instanceof SimpleDateFormat && (fmt = ((SimpleDateFormat)df).toPattern()) != null && !"M/d/yy h:mm a".equals(fmt)) {
            return fmt;
        }
        return "yyyy/MM/dd";
    }

    public boolean isLenient() {
        return this._lenient;
    }

    public void setLenient(boolean lenient) {
        if (this._lenient != lenient) {
            this._lenient = lenient;
            this.smartUpdate("lenient", this._lenient);
        }
    }

    public boolean isButtonVisible() {
        return this._btnVisible;
    }

    public void setButtonVisible(boolean visible) {
        if (this._btnVisible != visible) {
            this._btnVisible = visible;
            this.smartUpdate("buttonVisible", visible);
        }
    }

    public Date getValue() throws WrongValueException {
        return (Date)this.getTargetValue();
    }

    public void setValue(Date value) throws WrongValueException {
        if (value == null) {
            value = Dates.today();
        }
        this.validate(value);
        this.setRawValue(value);
    }

    public void setFormat(String format) throws WrongValueException {
        if (format == null || format.length() == 0) {
            format = this.getDefaultFormat();
        } else {
            this.getDateFormat(format);
        }
        super.setFormat(format);
    }

    public TimeZone getTimeZone() {
        return this._tzone;
    }

    public void setTimeZone(TimeZone tzone) {
        this._tzone = tzone;
    }

    public void setOpen(boolean open) {
        if (open) {
            this.open();
        } else {
            this.close();
        }
    }

    public void open() {
        this.smartUpdate("open", true);
    }

    public void close() {
        this.smartUpdate("open", false);
    }

    public void setConstraint(String constr) {
        this.setConstraint(constr != null ? new SimpleDateConstraint(constr) : null);
    }

    protected Object coerceFromString(String value) throws WrongValueException {
        Date date;
        if (value == null || value.length() == 0) {
            return null;
        }
        String fmt = this.getFormat();
        DateFormat df = this.getDateFormat(fmt);
        df.setLenient(this._lenient);
        try {
            date = df.parse(value);
        }
        catch (ParseException ex) {
            throw this.showCustomError(new WrongValueException((Component)this, MZul.DATE_REQUIRED, new Object[]{value, fmt}));
        }
        return date;
    }

    protected String coerceToString(Object value) {
        DateFormat df = this.getDateFormat(this.getFormat());
        return value != null ? df.format((Date)value) : "";
    }

    protected DateFormat getDateFormat(String fmt) {
        SimpleDateFormat df = new SimpleDateFormat(fmt, Locales.getCurrent());
        TimeZone tz = this._tzone != null ? this._tzone : TimeZones.getCurrent();
        df.setTimeZone(tz);
        return df;
    }

    public String getZclass() {
        return this._zclass == null ? "z-datebox" : this._zclass;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!this._btnVisible) {
            renderer.render("buttonVisible", false);
        }
        if (!this._lenient) {
            renderer.render("lenient", false);
        }
    }

    static {
        Datebox.addClientEvent((Class)Datebox.class, (String)"onFocus", (int)8192);
        Datebox.addClientEvent((Class)Datebox.class, (String)"onBlur", (int)8192);
        Datebox.addClientEvent((Class)Datebox.class, (String)"onChange", (int)16385);
    }
}

