/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.DynamicPropertied;
import org.zkoss.zk.ui.sys.ContentRenderer;

public class Applet
extends HtmlBasedComponent
implements DynamicPropertied,
org.zkoss.zul.api.Applet {
    private String _code = "";
    private String _codebase = "";
    private final Map _params = new LinkedHashMap();

    public String getCode() {
        return this._code;
    }

    public void setCode(String code) {
        this._code = code;
        this.invalidate();
    }

    public String getCodebase() {
        return this._codebase;
    }

    public void setCodebase(String codebase) {
        this._codebase = codebase;
        this.invalidate();
    }

    public void setParams(Map params) {
        this._params.clear();
        if (params != null) {
            this._params.putAll(params);
        }
        this.invalidate();
    }

    public Map getParams() {
        return this._params;
    }

    public String setParam(String name, String value) {
        return value != null ? this._params.put(name, value) : (String)this._params.remove(name);
    }

    public Object getDynamicProperty(String name) {
        return this._params.get(name);
    }

    public boolean hasDynamicProperty(String name) {
        return this._params.containsKey(name);
    }

    public void setDynamicProperty(String name, Object value) throws WrongValueException {
        this.setParam(name, Objects.toString((Object)value));
    }

    public void invoke(String function) {
        this.response(null, (AuResponse)new AuInvoke((Component)this, "invoke", (Object)function));
    }

    public void invoke(String function, String argument) {
        this.response(null, (AuResponse)new AuInvoke((Component)this, "invoke", (Object)function, (Object)argument));
    }

    public void invoke(String function, String[] arguments) {
        int len = arguments != null ? arguments.length : 0;
        String[] args = new String[len + 1];
        args[0] = function;
        for (int j = 0; j < len; ++j) {
            args[j + 1] = arguments[j];
        }
        this.response(null, (AuResponse)new AuInvoke((Component)this, "invoke", args));
    }

    public void setField(String field, String value) {
        this.response(null, (AuResponse)new AuInvoke((Component)this, "setField", (Object)field, (Object)value));
    }

    public boolean isChildable() {
        return false;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "code", this.getCode());
        this.render(renderer, "codebase", this.getCodebase());
        Iterator it = this._params.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            this.render(renderer, "param", new String[]{(String)me.getKey(), (String)me.getValue()});
        }
    }
}

