/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.event;

import org.zkoss.zul.TreeModel;

public class TreeDataEvent {
    public static final int CONTENTS_CHANGED = 0;
    public static final int INTERVAL_ADDED = 1;
    public static final int INTERVAL_REMOVED = 2;
    private final TreeModel _model;
    private final int _type;
    private final int _indexFrom;
    private final int _indexTo;
    private final Object _parent;

    public TreeDataEvent(TreeModel model, int type, Object parent, int indexFrom, int indexTo) {
        if (model == null) {
            throw new NullPointerException();
        }
        TreeDataEvent.checkInterval(indexFrom, indexTo, model.getChildCount(parent));
        this._model = model;
        this._type = type;
        this._parent = parent;
        this._indexFrom = indexFrom;
        this._indexTo = indexTo;
    }

    private static void checkInterval(int from, int to, int len) {
        if (from > to) {
            throw new IllegalArgumentException("'from' should be less than or equal to 'to'. from: " + from + ", to: " + to);
        }
        if (from < 0) {
            throw new ArrayIndexOutOfBoundsException("Out of bound. from : " + from);
        }
    }

    public TreeModel getModel() {
        return this._model;
    }

    public int getType() {
        return this._type;
    }

    public Object getParent() {
        return this._parent;
    }

    public int getIndexFrom() {
        return this._indexFrom;
    }

    public int getIndexTo() {
        return this._indexTo;
    }
}

