/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.List;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.ext.client.Openable;
import org.zkoss.zk.ui.ext.render.Transparent;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treecell;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treerow;
import org.zkoss.zul.impl.XulElement;

public class Treeitem
extends XulElement {
    private transient Treerow _treerow;
    private transient Treechildren _treechildren;
    private Object _value;
    private boolean _open = true;
    private boolean _selected = false;

    public Treeitem() {
    }

    public Treeitem(String label) {
        this.setLabel(label);
    }

    public Treeitem(String label, Object value) {
        this.setLabel(label);
        this.setValue(value);
    }

    public Treerow getTreerow() {
        return this._treerow;
    }

    public Treechildren getTreechildren() {
        return this._treechildren;
    }

    public boolean isContainer() {
        return this._treechildren != null;
    }

    public boolean isEmpty() {
        return this._treechildren == null || this._treechildren.getChildren().isEmpty();
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        if (!Objects.equals((Object)this._value, (Object)value)) {
            this._value = value;
            Tree tree = this.getTree();
            if (this._treerow != null && tree != null && tree.getName() != null) {
                this._treerow.smartUpdate("z:value", Objects.toString((Object)this._value));
            }
        }
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            this._open = open;
            Tree tree = this.getTree();
            if (tree != null && this._treerow != null) {
                tree.smartUpdate("open", this._treerow.getUuid() + ":" + this._open);
            }
        }
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean selected) {
        if (this._selected != selected) {
            Tree tree = this.getTree();
            if (tree != null) {
                tree.toggleItemSelection(this);
            } else {
                this._selected = selected;
            }
        }
    }

    void setSelectedDirectly(boolean selected) {
        this._selected = selected;
    }

    public int getLevel() {
        Component tch;
        int level = 0;
        Treeitem item = this;
        while ((tch = item.getParent()) != null && (item = tch.getParent()) != null && !(item instanceof Tree)) {
            ++level;
        }
        return level;
    }

    public String getLabel() {
        if (this._treerow == null) {
            return null;
        }
        List cells = this._treerow.getChildren();
        return cells.isEmpty() ? null : ((Treecell)((Object)cells.get(0))).getLabel();
    }

    public void setLabel(String label) {
        List cells;
        if (this._treerow == null) {
            new Treerow().setParent((Component)this);
        }
        if ((cells = this._treerow.getChildren()).isEmpty()) {
            new Treecell().setParent((Component)this._treerow);
        }
        ((Treecell)((Object)cells.get(0))).setLabel(label);
    }

    public String getSrc() {
        if (this._treerow == null) {
            return null;
        }
        List cells = this._treerow.getChildren();
        return cells.isEmpty() ? null : ((Treecell)((Object)cells.get(0))).getSrc();
    }

    public void setSrc(String src) {
        List cells;
        if (this._treerow == null) {
            new Treerow().setParent((Component)this);
        }
        if ((cells = this._treerow.getChildren()).isEmpty()) {
            new Treecell().setParent((Component)this._treerow);
        }
        ((Treecell)((Object)cells.get(0))).setSrc(src);
    }

    public String getImage() {
        return this.getSrc();
    }

    public void setImage(String image) {
        this.setSrc(image);
    }

    public Treeitem getTreeitem() {
        Component p = this.getParent();
        Component gp = p != null ? p.getParent() : null;
        return gp instanceof Treeitem ? (Treeitem)gp : null;
    }

    public Tree getTree() {
        Treeitem p = this;
        while ((p = p.getParent()) != null) {
            if (!(p instanceof Tree)) continue;
            return (Tree)((Object)p);
        }
        return null;
    }

    boolean isFocusRequired() {
        Tree tree = this.getTree();
        if (tree == null) {
            return false;
        }
        Treeitem sel = tree.getSelectedItem();
        if (sel != null) {
            return sel == this;
        }
        Iterator it = tree.getItems().iterator();
        return it.hasNext() && it.next() == this;
    }

    protected String getAllOnClickAttrs(boolean ignoreOnClick) {
        return super.getAllOnClickAttrs(ignoreOnClick);
    }

    protected boolean isAsapRequired(String evtnm) {
        return super.isAsapRequired(evtnm);
    }

    public boolean addEventListener(String evtnm, EventListener listener) {
        boolean asap = this._treerow == null || this.isAsapRequired(evtnm);
        boolean ret = super.addEventListener(evtnm, listener);
        if (ret && !asap && this.isAsapRequired(evtnm)) {
            this._treerow.smartUpdate("z:" + evtnm, "true");
        }
        return ret;
    }

    public boolean removeEventListener(String evtnm, EventListener listener) {
        boolean asap = this._treerow == null || this.isAsapRequired(evtnm);
        boolean ret = super.removeEventListener(evtnm, listener);
        if (ret && asap && !this.isAsapRequired(evtnm)) {
            this._treerow.smartUpdate("z:" + evtnm, null);
        }
        return ret;
    }

    public void smartUpdate(String attr, String value) {
        if ("z:ctx".equals(attr) || "z:pop".equals(attr) || "z:tip".equals(attr)) {
            if (this._treerow != null) {
                this._treerow.smartUpdate(attr, value);
            }
        } else {
            super.smartUpdate(attr, value);
        }
    }

    public void setParent(Component parent) {
        Tree tree;
        List sibs;
        int sz;
        List sibs2;
        int sz2;
        Component oldp = this.getParent();
        if (oldp == parent) {
            return;
        }
        if (parent != null && !(parent instanceof Treechildren)) {
            throw new UiException("Wrong parent: " + parent);
        }
        Treeitem affected = null;
        if (oldp != null && (sz2 = (sibs2 = oldp.getChildren()).size()) > 1 && sibs2.get(sibs2.size() - 1) == this) {
            affected = (Treeitem)((Object)sibs2.get(sibs2.size() - 2));
        }
        Tree oldtree = oldp != null ? this.getTree() : null;
        super.setParent(parent);
        if (affected != null) {
            if (affected._treerow != null) {
                affected._treerow.invalidate();
            }
            if (affected._treechildren != null) {
                affected._treechildren.invalidate();
            }
        }
        if (parent != null && (sz = (sibs = parent.getChildren()).size()) > 1 && sibs.get(sz - 1) == this) {
            affected = (Treeitem)((Object)sibs.get(sz - 2));
            if (affected._treerow != null) {
                affected._treerow.invalidate();
            }
            if (affected._treechildren != null) {
                affected._treechildren.invalidate();
            }
        }
        if (oldtree != null) {
            oldtree.onTreeitemRemoved(this);
        }
        if (parent != null && (tree = this.getTree()) != null) {
            tree.onTreeitemAdded(this);
        }
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (child instanceof Treerow) {
            if (this._treerow != null && this._treerow != child) {
                throw new UiException("Only one treerow is allowed: " + (Object)((Object)this));
            }
            this._treerow = (Treerow)child;
        } else if (child instanceof Treechildren) {
            if (this._treechildren != null && this._treechildren != child) {
                throw new UiException("Only one treechildren is allowed: " + (Object)((Object)this));
            }
            this._treechildren = (Treechildren)child;
            if (this._treerow != null) {
                this._treerow.invalidate();
            }
        } else {
            throw new UiException("Unsupported child for tree item: " + child);
        }
        return super.insertBefore(child, insertBefore);
    }

    public void onChildRemoved(Component child) {
        if (child instanceof Treerow) {
            this._treerow = null;
        } else if (child instanceof Treechildren) {
            this._treechildren = null;
        }
        super.onChildRemoved(child);
    }

    public Object clone() {
        Treeitem clone = (Treeitem)((Object)super.clone());
        int cnt = 0;
        if (clone._treerow != null) {
            ++cnt;
        }
        if (clone._treechildren != null) {
            ++cnt;
        }
        if (cnt > 0) {
            clone.afterUnmarshal(cnt);
        }
        return clone;
    }

    private void afterUnmarshal(int cnt) {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (child instanceof Treerow) {
                this._treerow = (Treerow)((Object)child);
                if (--cnt != 0) continue;
                break;
            }
            if (!(child instanceof Treechildren)) continue;
            this._treechildren = (Treechildren)((Object)child);
            if (--cnt != 0) continue;
            break;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.afterUnmarshal(-1);
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Openable,
    Transparent {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Treeitem.this);
        }

        public void setOpenByClient(boolean open) {
            Treeitem.this._open = open;
        }

        public boolean isTransparent() {
            return true;
        }
    }
}

