/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.client.Selectable;
import org.zkoss.zk.ui.ext.render.ChildChangedAware;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treecols;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Treerow;
import org.zkoss.zul.impl.XulElement;

public class Tree
extends XulElement {
    private transient Treecols _treecols;
    private transient Treechildren _treechildren;
    private transient Set _selItems;
    private transient Treeitem _sel;
    private int _rows = 0;
    private String _name;
    private boolean _multiple;
    private boolean _checkmark;
    private boolean _vflex;
    private transient boolean _noSmartUpdate;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Tree() {
        this.init();
        this.setSclass("tree");
    }

    private void init() {
        this._selItems = new LinkedHashSet(5);
    }

    public Treecols getTreecols() {
        return this._treecols;
    }

    public Treechildren getTreechildren() {
        return this._treechildren;
    }

    public int getRows() {
        return this._rows;
    }

    public void setRows(int rows) throws WrongValueException {
        if (rows < 0) {
            throw new WrongValueException("Illegal rows: " + rows);
        }
        if (this._rows != rows) {
            this._rows = rows;
            this.smartUpdate("z:size", Integer.toString(this._rows));
            this.initAtClient();
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            if (this._name != null) {
                this.smartUpdate("z:name", this._name);
            } else {
                this.invalidate();
            }
            this._name = name;
        }
    }

    public final boolean isCheckmark() {
        return this._checkmark;
    }

    public void setCheckmark(boolean checkmark) {
        if (this._checkmark != checkmark) {
            this._checkmark = checkmark;
            this.invalidate();
        }
    }

    public final boolean isVflex() {
        return this._vflex;
    }

    public void setVflex(boolean vflex) {
        if (this._vflex != vflex) {
            this._vflex = vflex;
            this.smartUpdate("z:flex", this._vflex);
        }
    }

    public String getSeltype() {
        return this._multiple ? "multiple" : "single";
    }

    public void setSeltype(String seltype) throws WrongValueException {
        if ("single".equals(seltype)) {
            this.setMultiple(false);
        } else if ("multiple".equals(seltype)) {
            this.setMultiple(true);
        } else {
            throw new WrongValueException("Unknown seltype: " + seltype);
        }
    }

    public boolean isMultiple() {
        return this._multiple;
    }

    public void setMultiple(boolean multiple) {
        if (this._multiple != multiple) {
            this._multiple = multiple;
            if (!this._multiple && this._selItems.size() > 1) {
                Treeitem item = this.getSelectedItem();
                this._selItems.clear();
                if (item != null) {
                    this._selItems.add(item);
                }
            }
            if (this.isCheckmark()) {
                this.invalidate();
            } else {
                this.smartUpdate("z:multiple", this._multiple);
            }
        }
    }

    private String getSelectedId() {
        Treerow tr = this._sel != null ? this._sel.getTreerow() : null;
        return tr != null ? tr.getUuid() : "zk_n_a";
    }

    public Collection getItems() {
        return this._treechildren != null ? this._treechildren.getItems() : Collections.EMPTY_LIST;
    }

    public int getItemCount() {
        return this._treechildren != null ? this._treechildren.getItemCount() : 0;
    }

    public void selectItem(Treeitem item) {
        if (item == null) {
            this.clearSelection();
        } else {
            if (item.getTree() != this) {
                throw new UiException("Not a child: " + (Object)((Object)item));
            }
            if (this._sel != item || this._multiple && this._selItems.size() > 1) {
                Iterator it = this._selItems.iterator();
                while (it.hasNext()) {
                    Treeitem ti = (Treeitem)((Object)it.next());
                    ti.setSelectedDirectly(false);
                }
                this._selItems.clear();
                this._sel = item;
                item.setSelectedDirectly(true);
                this._selItems.add(item);
                Treerow tr = item.getTreerow();
                if (tr != null) {
                    this.smartUpdate("select", tr.getUuid());
                }
            }
        }
    }

    public void addItemToSelection(Treeitem item) {
        if (item.getTree() != this) {
            throw new UiException("Not a child: " + (Object)((Object)item));
        }
        if (!item.isSelected()) {
            if (!this._multiple) {
                this.selectItem(item);
            } else {
                item.setSelectedDirectly(true);
                this._selItems.add(item);
                this.smartUpdateSelection();
                if (this.fixSelected()) {
                    this.smartUpdate("z:selId", this.getSelectedId());
                }
            }
        }
    }

    public void removeItemFromSelection(Treeitem item) {
        if (item.getTree() != this) {
            throw new UiException("Not a child: " + (Object)((Object)item));
        }
        if (item.isSelected()) {
            if (!this._multiple) {
                this.clearSelection();
            } else {
                item.setSelectedDirectly(false);
                this._selItems.remove((Object)item);
                this.smartUpdateSelection();
                if (this.fixSelected()) {
                    this.smartUpdate("z:selId", this.getSelectedId());
                }
            }
        }
    }

    private void smartUpdateSelection() {
        StringBuffer sb = new StringBuffer(80);
        Iterator it = this._selItems.iterator();
        while (it.hasNext()) {
            Treeitem item = (Treeitem)((Object)it.next());
            Treerow tr = item.getTreerow();
            if (tr == null) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(tr.getUuid());
        }
        this.smartUpdate("chgSel", sb.toString());
    }

    public void toggleItemSelection(Treeitem item) {
        if (item.isSelected()) {
            this.removeItemFromSelection(item);
        } else {
            this.addItemToSelection(item);
        }
    }

    public void clearSelection() {
        if (!this._selItems.isEmpty()) {
            Iterator it = this._selItems.iterator();
            while (it.hasNext()) {
                Treeitem item = (Treeitem)((Object)it.next());
                item.setSelectedDirectly(false);
            }
            this._selItems.clear();
            this._sel = null;
            this.smartUpdate("select", "");
        }
    }

    public void selectAll() {
        if (!this._multiple) {
            throw new UiException("Appliable only to the multiple seltype: " + (Object)((Object)this));
        }
        boolean changed = false;
        boolean first = true;
        Iterator it = this.getItems().iterator();
        while (it.hasNext()) {
            Treeitem item = (Treeitem)((Object)it.next());
            if (!item.isSelected()) {
                this._selItems.add(item);
                item.setSelectedDirectly(true);
                changed = true;
            }
            if (!first) continue;
            this._sel = item;
            first = false;
        }
        this.smartUpdate("selectAll", "true");
    }

    public Treeitem getSelectedItem() {
        return this._sel;
    }

    public void setSelectedItem(Treeitem item) {
        this.selectItem(item);
    }

    public Set getSelectedItems() {
        return Collections.unmodifiableSet(this._selItems);
    }

    public int getSelectedCount() {
        return this._selItems.size();
    }

    public void clear() {
        if (this._treechildren == null) {
            return;
        }
        List l = this._treechildren.getChildren();
        if (l.isEmpty()) {
            return;
        }
        Iterator it = new ArrayList(l).iterator();
        while (it.hasNext()) {
            ((Component)it.next()).detach();
        }
    }

    void initAtClient() {
        this.smartUpdate("z:init", true);
    }

    public void setHeight(String height) {
        if (!Objects.equals((Object)height, (Object)this.getHeight())) {
            super.setHeight(height);
            this.initAtClient();
        }
    }

    public void smartUpdate(String attr, String value) {
        if (!this._noSmartUpdate) {
            super.smartUpdate(attr, value);
        }
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (child instanceof Treecols) {
            if (this._treecols != null && this._treecols != child) {
                throw new UiException("Only one treecols is allowed: " + (Object)((Object)this));
            }
            if (!this.getChildren().isEmpty()) {
                insertBefore = (Component)this.getChildren().get(0);
            }
            this._treecols = (Treecols)child;
            this.invalidate();
        } else if (child instanceof Treechildren) {
            if (this._treechildren != null && this._treechildren != child) {
                throw new UiException("Only one treechildren is allowed: " + (Object)((Object)this));
            }
            if (insertBefore instanceof Treecols) {
                throw new UiException("treecols must be the first child");
            }
            this._treechildren = (Treechildren)child;
            this.invalidate();
            this.fixSelectedSet();
        } else {
            throw new UiException("Unsupported child for tree: " + child);
        }
        return super.insertBefore(child, insertBefore);
    }

    void onTreeitemAdded(Treeitem item) {
        this.fixNewChild(item);
        this.onTreechildrenAdded(item.getTreechildren());
    }

    void onTreeitemRemoved(Treeitem item) {
        boolean fixSel = false;
        if (item.isSelected()) {
            this._selItems.remove((Object)item);
            boolean bl = fixSel = this._sel == item;
            if (fixSel && !this._multiple) {
                this._sel = null;
                this.smartUpdate("z:selId", this.getSelectedId());
                if (!$assertionsDisabled && !this._selItems.isEmpty()) {
                    throw new AssertionError();
                }
            }
        }
        this.onTreechildrenRemoved(item.getTreechildren());
        if (fixSel) {
            this.fixSelected();
        }
    }

    void onTreechildrenAdded(Treechildren tchs) {
        if (tchs == null || tchs.getParent() == this) {
            return;
        }
        Iterator it = tchs.getItems().iterator();
        while (it.hasNext()) {
            this.fixNewChild((Treeitem)((Object)it.next()));
        }
    }

    private void fixNewChild(Treeitem item) {
        if (item.isSelected()) {
            if (this._sel != null && !this._multiple) {
                item.setSelectedDirectly(false);
                item.invalidate();
            } else {
                if (this._sel == null) {
                    this._sel = item;
                }
                this._selItems.add(item);
                this.smartUpdate("z:selId", this.getSelectedId());
            }
        }
    }

    void onTreechildrenRemoved(Treechildren tchs) {
        if (tchs == null || tchs.getParent() == this) {
            return;
        }
        boolean fixSel = false;
        Iterator it = tchs.getItems().iterator();
        while (it.hasNext()) {
            Treeitem item = (Treeitem)((Object)it.next());
            if (!item.isSelected()) continue;
            this._selItems.remove((Object)item);
            if (this._sel != item) continue;
            if (!this._multiple) {
                this._sel = null;
                this.smartUpdate("z:selId", this.getSelectedId());
                if (!$assertionsDisabled && !this._selItems.isEmpty()) {
                    throw new AssertionError();
                }
                return;
            }
            fixSel = true;
        }
        if (fixSel) {
            this.fixSelected();
        }
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        this.invalidate();
    }

    public void onChildRemoved(Component child) {
        if (child instanceof Treecols) {
            this._treecols = null;
        } else if (child instanceof Treechildren) {
            this._treechildren = null;
            this._selItems.clear();
            this._sel = null;
        }
        super.onChildRemoved(child);
        this.invalidate();
    }

    private void fixSelectedSet() {
        this._sel = null;
        this._selItems.clear();
        Iterator it = this.getItems().iterator();
        while (it.hasNext()) {
            Treeitem item = (Treeitem)((Object)it.next());
            if (!item.isSelected()) continue;
            if (this._sel == null) {
                this._sel = item;
            } else if (!this._multiple) {
                item.setSelectedDirectly(false);
                continue;
            }
            this._selItems.add(item);
        }
    }

    private boolean fixSelected() {
        Treeitem sel = null;
        block0 : switch (this._selItems.size()) {
            case 1: {
                sel = (Treeitem)((Object)this._selItems.iterator().next());
            }
            case 0: {
                break;
            }
            default: {
                Iterator it = this.getItems().iterator();
                while (it.hasNext()) {
                    Treeitem item = (Treeitem)((Object)it.next());
                    if (!item.isSelected()) continue;
                    sel = item;
                    break block0;
                }
                break block0;
            }
        }
        if (sel != this._sel) {
            this._sel = sel;
            return true;
        }
        return false;
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z:name", (String)this._name);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z:size", (int)this.getRows());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z:selId", (String)this.getSelectedId());
        if (this._multiple) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z:multiple", (boolean)true);
        }
        if (this._vflex) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z:vflex", (boolean)true);
        }
        this.appendAsapAttr(sb, "onSelect");
        return sb.toString();
    }

    public Object clone() {
        int cntSel = this._selItems.size();
        Tree clone = (Tree)((Object)super.clone());
        clone.init();
        int cnt = 0;
        if (this._treecols != null) {
            ++cnt;
        }
        if (this._treechildren != null) {
            ++cnt;
        }
        if (cnt > 0 || cntSel > 0) {
            clone.afterUnmarshal(cnt, cntSel);
        }
        return clone;
    }

    private void afterUnmarshal(int cnt, int cntSel) {
        Iterator it;
        if (cnt != 0) {
            it = this.getChildren().iterator();
            while (it.hasNext()) {
                Object child = it.next();
                if (child instanceof Treecols) {
                    this._treecols = (Treecols)((Object)child);
                    if (--cnt != 0) continue;
                    break;
                }
                if (!(child instanceof Treechildren)) continue;
                this._treechildren = (Treechildren)((Object)child);
                if (--cnt != 0) continue;
                break;
            }
        }
        this._sel = null;
        this._selItems.clear();
        if (cntSel != 0) {
            it = this.getItems().iterator();
            while (it.hasNext()) {
                Treeitem ti = (Treeitem)((Object)it.next());
                if (!ti.isSelected()) continue;
                if (this._sel == null) {
                    this._sel = ti;
                }
                this._selItems.add(ti);
                if (--cntSel != 0) continue;
                break;
            }
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        this.afterUnmarshal(-1, -1);
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    static {
        $assertionsDisabled = !Tree.class.desiredAssertionStatus();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Selectable,
    ChildChangedAware {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Tree.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void selectItemsByClient(Set selItems) {
            Tree.this._noSmartUpdate = true;
            try {
                if (!Tree.this._multiple || selItems == null || selItems.size() <= 1) {
                    Treeitem item = selItems != null && selItems.size() > 0 ? (Treeitem)((Object)selItems.iterator().next()) : null;
                    Tree.this.selectItem(item);
                } else {
                    Iterator it = new ArrayList(Tree.this._selItems).iterator();
                    while (it.hasNext()) {
                        Treeitem item = (Treeitem)((Object)it.next());
                        if (selItems.remove((Object)item)) continue;
                        Tree.this.removeItemFromSelection(item);
                    }
                    it = selItems.iterator();
                    while (it.hasNext()) {
                        Tree.this.addItemToSelection((Treeitem)((Object)it.next()));
                    }
                }
            }
            finally {
                Tree.this._noSmartUpdate = false;
            }
        }

        public boolean isChildChangedAware() {
            return true;
        }
    }
}

