/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Tabbox;
import org.zkoss.zul.impl.XulElement;

public class Tabs
extends XulElement {
    public Tabbox getTabbox() {
        return (Tabbox)this.getParent();
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Tabbox)) {
            throw new UiException("Wrong parent: " + parent);
        }
        Tabbox oldp = (Tabbox)this.getParent();
        super.setParent(parent);
        Tabs.invalidateIfAccordion(oldp);
        Tabs.invalidateIfAccordion((Tabbox)parent);
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (!(child instanceof Tab)) {
            throw new UiException("Unsupported child for tabs: " + child);
        }
        boolean empty = this.getChildren().isEmpty();
        Tab newtab = (Tab)child;
        if (!empty && newtab.isSelected()) {
            newtab.setSelectedDirectly(false);
        }
        if (super.insertBefore(child, insertBefore)) {
            Tabbox tabbox = this.getTabbox();
            if (empty && tabbox != null) {
                tabbox.setSelectedTab(newtab);
            }
            Tabs.invalidateIfAccordion(tabbox);
            return true;
        }
        return false;
    }

    private static void invalidateIfAccordion(Tabbox tabbox) {
        if (tabbox != null && "accordion".equals(tabbox.getMold())) {
            tabbox.invalidate();
        }
    }
}

