/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.Iterator;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.Tabbox;
import org.zkoss.zul.Tabpanel;
import org.zkoss.zul.Tabpanels;
import org.zkoss.zul.Tabs;
import org.zkoss.zul.impl.LabelImageElement;

public class Tab
extends LabelImageElement {
    private boolean _selected;

    public Tab() {
    }

    public Tab(String label) {
        this.setLabel(label);
    }

    public Tab(String label, String image) {
        this.setLabel(label);
        this.setImage(image);
    }

    public Tabbox getTabbox() {
        Tabs tabs = (Tabs)this.getParent();
        return tabs != null ? tabs.getTabbox() : null;
    }

    public Tabpanel getLinkedPanel() {
        Tabpanels tabpanels;
        Tabbox tabbox;
        int j = this.getIndex();
        if (j >= 0 && (tabbox = this.getTabbox()) != null && (tabpanels = tabbox.getTabpanels()) != null && tabpanels.getChildren().size() > j) {
            return (Tabpanel)((Object)tabpanels.getChildren().get(j));
        }
        return null;
    }

    public final boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean selected) {
        if (this._selected != selected) {
            Tabbox tabbox = this.getTabbox();
            if (tabbox != null) {
                tabbox.setSelectedTab(this);
            } else {
                this._selected = selected;
                this.invalidate();
            }
        }
    }

    void setSelectedDirectly(boolean selected) {
        this._selected = selected;
    }

    public int getIndex() {
        Tabs tabs = (Tabs)this.getParent();
        if (tabs == null) {
            return -1;
        }
        int j = 0;
        Iterator it = tabs.getChildren().iterator();
        while (it.next() != this) {
            ++j;
        }
        return j;
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        String clkattrs = this.getAllOnClickAttrs(true);
        return clkattrs == null ? attrs : attrs + clkattrs;
    }

    public String getSclass() {
        String scls = super.getSclass();
        if (scls == null) {
            scls = "tab";
        }
        return this.isSelected() ? scls + "sel" : scls;
    }

    public void invalidate() {
        Tabbox tabbox = this.getTabbox();
        if (tabbox != null && "accordion".equals(tabbox.getMold())) {
            tabbox.invalidate();
        } else {
            super.invalidate();
        }
    }

    public boolean isChildable() {
        return false;
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Tabs)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.setParent(parent);
    }
}

