/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zul.AbstractChartModel;
import org.zkoss.zul.CategoryModel;

public class SimpleCategoryModel
extends AbstractChartModel
implements CategoryModel {
    private Map _seriesMap = new HashMap(13);
    private List _seriesList = new ArrayList(13);
    private Map _categoryMap = new HashMap(13);
    private List _categoryList = new ArrayList(13);
    private Map _valueMap = new LinkedHashMap(79);

    public Comparable getSeries(int index) {
        return (Comparable)this._seriesList.get(index);
    }

    public Comparable getCategory(int index) {
        return (Comparable)this._categoryList.get(index);
    }

    public Collection getSeries() {
        return this._seriesList;
    }

    public Collection getCategories() {
        return this._categoryList;
    }

    public Collection getKeys() {
        return this._valueMap.keySet();
    }

    public Number getValue(Comparable series, Comparable category) {
        ArrayList<Comparable> key = new ArrayList<Comparable>(2);
        key.add(series);
        key.add(category);
        Number num = (Number)this._valueMap.get(key);
        return num;
    }

    public void setValue(Comparable series, Comparable category, Number value) {
        ArrayList<Comparable> key = new ArrayList<Comparable>(2);
        key.add(series);
        key.add(category);
        if (!this._valueMap.containsKey(key)) {
            Integer count;
            if (!this._categoryMap.containsKey(category)) {
                this._categoryMap.put(category, new Integer(1));
                this._categoryList.add(category);
            } else {
                count = (Integer)this._categoryMap.get(category);
                this._categoryMap.put(category, new Integer(count + 1));
            }
            if (!this._seriesMap.containsKey(series)) {
                this._seriesMap.put(series, new Integer(1));
                this._seriesList.add(series);
            } else {
                count = (Integer)this._seriesMap.get(series);
                this._seriesMap.put(series, new Integer(count + 1));
            }
        } else {
            Number ovalue = (Number)this._valueMap.get(key);
            if (Objects.equals((Object)ovalue, (Object)value)) {
                return;
            }
        }
        this._valueMap.put(key, value);
        this.fireEvent(0, (Comparable)((Object)((String)((Object)series))), category);
    }

    public void removeValue(Comparable series, Comparable category) {
        ArrayList<Comparable> key = new ArrayList<Comparable>(2);
        key.add(series);
        key.add(category);
        if (!this._valueMap.containsKey(key)) {
            return;
        }
        this._valueMap.remove(key);
        int ccount = (Integer)this._categoryMap.get(category);
        if (ccount > 1) {
            this._categoryMap.put(category, new Integer(ccount - 1));
        } else {
            this._categoryMap.remove(category);
            this._categoryList.remove(category);
        }
        int scount = (Integer)this._seriesMap.get(series);
        if (scount > 1) {
            this._seriesMap.put(series, new Integer(scount - 1));
        } else {
            this._seriesMap.remove(series);
            this._seriesList.remove(series);
        }
        this.fireEvent(2, (Comparable)((Object)((String)((Object)series))), category);
    }

    public void clear() {
        this._seriesMap.clear();
        this._seriesList.clear();
        this._categoryMap.clear();
        this._categoryList.clear();
        this._valueMap.clear();
        this.fireEvent(2, null, null);
    }
}

