/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.boot.actuate;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.togglz.core.Feature;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.metadata.FeatureMetaData;
import org.togglz.core.repository.FeatureState;
import org.togglz.spring.boot.actuate.AbstractTogglzEndpoint;
import org.togglz.spring.boot.actuate.autoconfigure.TogglzFeature;
import org.togglz.spring.boot.actuate.autoconfigure.TogglzFeatureMetaData;

@Component
@Endpoint(id="togglz")
public class TogglzEndpoint
extends AbstractTogglzEndpoint {
    public TogglzEndpoint(FeatureManager featureManager) {
        super(featureManager);
    }

    @ReadOperation
    public List<TogglzFeature> getAllFeatures() {
        return this.featureManager.getFeatures().stream().map(this::generateTogglzFeature).sorted().collect(Collectors.toList());
    }

    @ReadOperation
    public TogglzFeature getFeature(@Selector String name) {
        return this.featureManager.getFeatures().stream().filter(it -> name.equals(it.name())).findFirst().map(this::generateTogglzFeature).orElse(null);
    }

    @WriteOperation
    public TogglzFeature setFeatureState(@Selector String name, @Nullable Boolean enabled, @Nullable String strategy, @Nullable String parameters) {
        Feature feature = this.findFeature(name);
        if (feature == null) {
            throw new IllegalArgumentException("Could not find feature with name " + name);
        }
        Map<String, String> parametersMap = this.parseParameterMap(parameters);
        FeatureState featureState = this.changeFeatureStatus(feature, enabled, strategy, parametersMap);
        FeatureMetaData metaData = this.featureManager.getMetaData(feature);
        return new TogglzFeature(feature, featureState, new TogglzFeatureMetaData(metaData));
    }
}

