/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.oracle;

import io.r2dbc.spi.ConnectionFactoryOptions;
import java.util.Set;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.oracle.OracleContainer;
import org.testcontainers.r2dbc.R2DBCDatabaseContainer;

public class OracleR2DBCDatabaseContainer
implements R2DBCDatabaseContainer {
    private final OracleContainer container;

    public static ConnectionFactoryOptions getOptions(OracleContainer container) {
        ConnectionFactoryOptions options = ConnectionFactoryOptions.builder().option(ConnectionFactoryOptions.DRIVER, (Object)"oracle").build();
        return new OracleR2DBCDatabaseContainer(container).configure(options);
    }

    public ConnectionFactoryOptions configure(ConnectionFactoryOptions options) {
        return options.mutate().option(ConnectionFactoryOptions.HOST, (Object)this.container.getHost()).option(ConnectionFactoryOptions.PORT, (Object)this.container.getMappedPort(1521)).option(ConnectionFactoryOptions.DATABASE, (Object)this.container.getDatabaseName()).option(ConnectionFactoryOptions.USER, (Object)this.container.getUsername()).option(ConnectionFactoryOptions.PASSWORD, (Object)this.container.getPassword()).build();
    }

    public OracleR2DBCDatabaseContainer(OracleContainer container) {
        this.container = container;
    }

    public Set<Startable> getDependencies() {
        return this.container.getDependencies();
    }

    public void start() {
        this.container.start();
    }

    public void stop() {
        this.container.stop();
    }

    public void close() {
        this.container.close();
    }
}

