/*
 * Decompiled with CFR 0.152.
 */
package tachyon.util.io;

import com.google.common.base.Preconditions;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;

public final class BufferUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private static Method sCleanerCleanMethod;
    private static Method sByteBufferCleanerMethod;

    public static int byteToInt(byte b) {
        return b & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanDirectBuffer(ByteBuffer buffer) {
        Preconditions.checkNotNull((Object)buffer);
        Preconditions.checkArgument((boolean)buffer.isDirect(), (Object)"buffer isn't a DirectByteBuffer");
        try {
            Object cleaner;
            if (sByteBufferCleanerMethod == null) {
                sByteBufferCleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
                sByteBufferCleanerMethod.setAccessible(true);
            }
            if ((cleaner = sByteBufferCleanerMethod.invoke((Object)buffer, new Object[0])) == null) {
                LOG.error("Failed to get cleaner for ByteBuffer");
                return;
            }
            if (sCleanerCleanMethod == null) {
                sCleanerCleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
            }
            sCleanerCleanMethod.invoke(cleaner, new Object[0]);
        }
        catch (Exception e) {
            LOG.warn("Fail to unmap direct buffer due to " + e.getMessage(), (Throwable)e);
        }
        finally {
            buffer = null;
        }
    }

    public static ByteBuffer cloneByteBuffer(ByteBuffer buf) {
        ByteBuffer ret = ByteBuffer.allocate(buf.limit() - buf.position());
        if (buf.hasArray()) {
            ret.put(buf.array(), buf.position(), buf.limit() - buf.position());
        } else {
            ret.put(buf);
        }
        ret.flip();
        return ret;
    }

    public static List<ByteBuffer> cloneByteBufferList(List<ByteBuffer> source) {
        ArrayList<ByteBuffer> ret = new ArrayList<ByteBuffer>(source.size());
        for (ByteBuffer b : source) {
            ret.add(BufferUtils.cloneByteBuffer(b));
        }
        return ret;
    }

    public static ByteBuffer generateNewByteBufferFromThriftRPCResults(ByteBuffer data) {
        ByteBuffer correctData = ByteBuffer.allocate(data.limit() - data.position());
        correctData.put(data);
        correctData.flip();
        return correctData;
    }

    public static void putIntByteBuffer(ByteBuffer buf, int b) {
        buf.put((byte)(b & 0xFF));
    }

    public static byte[] getIncreasingByteArray(int len) {
        return BufferUtils.getIncreasingByteArray(0, len);
    }

    public static byte[] getIncreasingByteArray(int start, int len) {
        byte[] ret = new byte[len];
        for (int k = 0; k < len; ++k) {
            ret[k] = (byte)(k + start);
        }
        return ret;
    }

    public static boolean equalIncreasingByteArray(int len, byte[] arr) {
        return BufferUtils.equalIncreasingByteArray(0, len, arr);
    }

    public static boolean equalIncreasingByteArray(int start, int len, byte[] arr) {
        if (arr == null || arr.length != len) {
            return false;
        }
        for (int k = 0; k < len; ++k) {
            if (arr[k] == (byte)(start + k)) continue;
            return false;
        }
        return true;
    }

    public static ByteBuffer getIncreasingByteBuffer(int len) {
        return BufferUtils.getIncreasingByteBuffer(0, len);
    }

    public static ByteBuffer getIncreasingByteBuffer(int start, int len) {
        return ByteBuffer.wrap(BufferUtils.getIncreasingByteArray(start, len));
    }

    public static boolean equalIncreasingByteBuffer(int start, int len, ByteBuffer buf) {
        if (buf == null) {
            return false;
        }
        buf.rewind();
        if (buf.remaining() != len) {
            return false;
        }
        for (int k = 0; k < len; ++k) {
            if (buf.get() == (byte)(start + k)) continue;
            return false;
        }
        return true;
    }

    public static ByteBuffer getIncreasingIntBuffer(int len) {
        return BufferUtils.getIncreasingIntBuffer(0, len);
    }

    public static ByteBuffer getIncreasingIntBuffer(int start, int len) {
        ByteBuffer ret = ByteBuffer.allocate(len * 4);
        for (int k = 0; k < len; ++k) {
            ret.putInt(start + k);
        }
        ret.flip();
        return ret;
    }

    public static void writeBufferToFile(String path, byte[] buffer) throws IOException {
        FileOutputStream os = new FileOutputStream(path);
        os.write(buffer);
        os.close();
    }

    public static void fastCopy(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }

    private BufferUtils() {
    }
}

