/*
 * Decompiled with CFR 0.152.
 */
package tachyon.collections;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;

public class IndexedSet<T>
implements Iterable<T> {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final Set<T> mObjects = new HashSet<T>();
    private final Map<FieldIndex<T>, Integer> mIndexMap;
    private final List<Map<Object, Set<T>>> mSetIndexedByFieldValue;
    private final Object mLock = new Object();

    public IndexedSet(FieldIndex<T> field, FieldIndex<T> ... otherFields) {
        int i;
        this.mIndexMap = new HashMap<FieldIndex<T>, Integer>(otherFields.length + 1);
        this.mIndexMap.put(field, 0);
        for (i = 1; i <= otherFields.length; ++i) {
            this.mIndexMap.put(otherFields[i - 1], i);
        }
        this.mSetIndexedByFieldValue = new ArrayList<Map<Object, Set<T>>>(this.mIndexMap.size());
        for (i = 0; i < this.mIndexMap.size(); ++i) {
            this.mSetIndexedByFieldValue.add(new HashMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            this.mObjects.clear();
            for (Map<Object, Set<T>> mapping : this.mSetIndexedByFieldValue) {
                mapping.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T objToAdd) {
        Preconditions.checkNotNull(objToAdd);
        Object object = this.mLock;
        synchronized (object) {
            boolean success = this.mObjects.add(objToAdd);
            if (success) {
                for (Map.Entry<FieldIndex<T>, Integer> index : this.mIndexMap.entrySet()) {
                    Object fieldValue;
                    Map<Object, Set<T>> fieldValueToSet = this.mSetIndexedByFieldValue.get(index.getValue());
                    if (fieldValueToSet.containsKey(fieldValue = index.getKey().getFieldValue(objToAdd))) {
                        success = fieldValueToSet.get(fieldValue).add(objToAdd);
                        if (success) continue;
                        throw new IllegalStateException("Indexed Set is in an illegal state");
                    }
                    fieldValueToSet.put(fieldValue, Sets.newHashSet((Object[])new Object[]{objToAdd}));
                }
            }
            return success;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new IndexedSetIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(FieldIndex<T> index, Object value) {
        Object object = this.mLock;
        synchronized (object) {
            return this.getByFieldInternal(index, value) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> getByField(FieldIndex<T> index, Object value) {
        Object object = this.mLock;
        synchronized (object) {
            HashSet set = this.getByFieldInternal(index, value);
            return set == null ? new HashSet() : set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getFirstByField(FieldIndex<T> index, Object value) {
        Object object = this.mLock;
        synchronized (object) {
            Set<T> all = this.getByFieldInternal(index, value);
            return all == null ? null : (T)all.iterator().next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T object) {
        Object object2 = this.mLock;
        synchronized (object2) {
            boolean success = this.mObjects.remove(object);
            if (success) {
                this.removeFromIndices(object);
            }
            return success;
        }
    }

    private void removeFromIndices(T object) {
        for (Map.Entry<FieldIndex<T>, Integer> index : this.mIndexMap.entrySet()) {
            Object fieldValue = index.getKey().getFieldValue(object);
            Map<Object, Set<T>> fieldValueToSet = this.mSetIndexedByFieldValue.get(index.getValue());
            Set<T> set = fieldValueToSet.get(fieldValue);
            if (set == null) continue;
            if (!set.remove(object)) {
                throw new IllegalStateException("Fail to remove object " + object.toString() + "from IndexedSet.");
            }
            if (!set.isEmpty()) continue;
            fieldValueToSet.remove(fieldValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeByField(FieldIndex<T> index, Object value) {
        Object object = this.mLock;
        synchronized (object) {
            ImmutableSet toRemove = this.getByFieldInternal(index, value);
            if (toRemove == null) {
                return false;
            }
            toRemove = ImmutableSet.copyOf(toRemove);
            boolean success = true;
            for (Object o : toRemove) {
                success = success && this.remove(o);
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mObjects.size();
        }
    }

    private Set<T> getByFieldInternal(FieldIndex<T> index, Object value) {
        return this.mSetIndexedByFieldValue.get(this.mIndexMap.get(index)).get(value);
    }

    private class IndexedSetIterator
    implements Iterator<T> {
        private final Iterator<T> mSetIterator;
        private T mLast;

        public IndexedSetIterator() {
            this.mSetIterator = IndexedSet.this.mObjects.iterator();
            this.mLast = null;
        }

        @Override
        public boolean hasNext() {
            return this.mSetIterator.hasNext();
        }

        @Override
        public T next() {
            Object next = this.mSetIterator.next();
            this.mLast = next;
            return next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.mLast != null) {
                Object object = IndexedSet.this.mLock;
                synchronized (object) {
                    this.mSetIterator.remove();
                    IndexedSet.this.removeFromIndices(this.mLast);
                    this.mLast = null;
                }
            } else {
                throw new IllegalStateException("Next was never called before");
            }
        }
    }

    public static interface FieldIndex<T> {
        public Object getFieldValue(T var1);
    }
}

