/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.block;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import tachyon.client.Cancelable;
import tachyon.client.ClientContext;
import tachyon.client.block.BlockStoreContext;
import tachyon.conf.TachyonConf;
import tachyon.util.io.BufferUtils;

public abstract class BufferedBlockOutStream
extends OutputStream
implements Cancelable {
    private static final String ERR_CLOSED = "Cannot do operations on a closed BlockOutStream.";
    private static final String ERR_END_OF_BLOCK = "Cannot write past end of block.";
    protected final long mBlockId;
    protected final long mBlockSize;
    protected final BlockStoreContext mContext;
    protected final ByteBuffer mBuffer;
    protected boolean mClosed;
    protected long mFlushedBytes;
    protected long mWrittenBytes;

    public BufferedBlockOutStream(long blockId, long blockSize) {
        this.mBlockId = blockId;
        this.mBlockSize = blockSize;
        this.mBuffer = this.allocateBuffer();
        this.mClosed = false;
        this.mContext = BlockStoreContext.INSTANCE;
    }

    public long remaining() {
        return this.mBlockSize - this.mWrittenBytes;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkIfClosed();
        Preconditions.checkState((this.mWrittenBytes + 1L <= this.mBlockSize ? 1 : 0) != 0, (Object)ERR_END_OF_BLOCK);
        if (this.mBuffer.position() >= this.mBuffer.limit()) {
            this.flush();
        }
        BufferUtils.putIntByteBuffer(this.mBuffer, b);
        ++this.mWrittenBytes;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (this.mBuffer.position() > 0 && this.mBuffer.position() + len > this.mBuffer.limit()) {
            this.flush();
        }
        if (len > this.mBuffer.limit() / 2) {
            if (this.mBuffer.position() > 0) {
                this.flush();
            }
            this.unBufferedWrite(b, off, len);
        } else {
            this.mBuffer.put(b, off, len);
        }
        this.mWrittenBytes += (long)len;
    }

    protected void checkIfClosed() {
        Preconditions.checkState((!this.mClosed ? 1 : 0) != 0, (Object)ERR_CLOSED);
    }

    protected abstract void unBufferedWrite(byte[] var1, int var2, int var3) throws IOException;

    private ByteBuffer allocateBuffer() {
        TachyonConf conf = ClientContext.getConf();
        return ByteBuffer.allocate((int)conf.getBytes("tachyon.user.file.buffer.bytes"));
    }
}

