/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import tachyon.client.TachyonFS;

public final class TachyonByteBuffer
implements Closeable {
    public final ByteBuffer mData;
    private final long mBlockId;
    private final int mBlockLockId;
    private final TachyonFS mTachyonFS;
    private boolean mClosed = false;

    TachyonByteBuffer(TachyonFS tfs, ByteBuffer buf, long blockId, int blockLockId) {
        this.mTachyonFS = (TachyonFS)Preconditions.checkNotNull((Object)tfs);
        this.mData = (ByteBuffer)Preconditions.checkNotNull((Object)buf);
        this.mBlockId = blockId;
        this.mBlockLockId = blockLockId;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        if (this.mBlockLockId >= 0) {
            this.mTachyonFS.unlockBlock(this.mBlockId, this.mBlockLockId);
        }
    }
}

