/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.MasterClientBase;
import tachyon.TachyonURI;
import tachyon.client.file.options.CreateOptions;
import tachyon.client.file.options.MkdirOptions;
import tachyon.conf.TachyonConf;
import tachyon.exception.TachyonException;
import tachyon.org.apache.thrift.TException;
import tachyon.thrift.FileBlockInfo;
import tachyon.thrift.FileInfo;
import tachyon.thrift.FileSystemMasterService;
import tachyon.thrift.TachyonTException;

public final class FileSystemMasterClient
extends MasterClientBase {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private FileSystemMasterService.Client mClient = null;

    public FileSystemMasterClient(InetSocketAddress masterAddress, TachyonConf tachyonConf) {
        super(masterAddress, tachyonConf);
    }

    @Override
    protected String getServiceName() {
        return "FileSystemMaster";
    }

    @Override
    protected void afterConnect() {
        this.mClient = new FileSystemMasterService.Client(this.mProtocol);
    }

    public synchronized long getFileId(String path) throws IOException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.getFileId(path);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized FileInfo getFileInfo(long fileId) throws IOException, TachyonException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.getFileInfo(fileId);
            }
            catch (TachyonTException e) {
                throw new TachyonException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized List<FileInfo> getFileInfoList(long fileId) throws IOException, TachyonException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.getFileInfoList(fileId);
            }
            catch (TachyonTException e) {
                throw new TachyonException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized FileBlockInfo getFileBlockInfo(long fileId, int fileBlockIndex) throws IOException, TachyonException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.getFileBlockInfo(fileId, fileBlockIndex);
            }
            catch (TachyonTException e) {
                throw new TachyonException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized List<FileBlockInfo> getFileBlockInfoList(long fileId) throws IOException, TachyonException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.getFileBlockInfoList(fileId);
            }
            catch (TachyonTException e) {
                throw new TachyonException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized long getNewBlockIdForFile(long fileId) throws IOException, TachyonException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.getNewBlockIdForFile(fileId);
            }
            catch (TachyonTException e) {
                throw new TachyonException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized String getUfsAddress() throws IOException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.getUfsAddress();
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized long create(String path, CreateOptions options) throws IOException, TachyonException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.create(path, options.toThrift());
            }
            catch (TachyonTException e) {
                throw new TachyonException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized void completeFile(long fileId) throws IOException, TachyonException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                this.mClient.completeFile(fileId);
                return;
            }
            catch (TachyonTException e) {
                throw new TachyonException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized boolean deleteFile(long fileId, boolean recursive) throws IOException, TachyonException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.deleteFile(fileId, recursive);
            }
            catch (TachyonTException e) {
                throw new TachyonException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized boolean renameFile(long fileId, String dstPath) throws IOException, TachyonException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.renameFile(fileId, dstPath);
            }
            catch (TachyonTException e) {
                throw new TachyonException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized void setPinned(long fileId, boolean pinned) throws IOException, TachyonException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                this.mClient.setPinned(fileId, pinned);
                return;
            }
            catch (TachyonTException e) {
                throw new TachyonException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized boolean mkdir(String path, MkdirOptions options) throws IOException, TachyonException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.mkdir(path, options.toThrift());
            }
            catch (TachyonTException e) {
                throw new TachyonException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized boolean free(long fileId, boolean recursive) throws IOException, TachyonException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.free(fileId, recursive);
            }
            catch (TachyonTException e) {
                throw new TachyonException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized void reportLostFile(long fileId) throws IOException, TachyonException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                this.mClient.reportLostFile(fileId);
            }
            catch (TachyonTException e) {
                throw new TachyonException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized long loadMetadata(String path, boolean recursive) throws IOException, TachyonException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.loadMetadata(path, recursive);
            }
            catch (TachyonTException e) {
                throw new TachyonException(e);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized boolean mount(TachyonURI tachyonPath, TachyonURI ufsPath) throws IOException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.mount(tachyonPath.toString(), ufsPath.toString());
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized boolean unmount(TachyonURI tachyonPath) throws IOException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.unmount(tachyonPath.toString());
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }
}

