/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import java.util.Collections;
import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.http.codec.json.AbstractJackson2Decoder;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;

public class Jackson2SmileDecoder
extends AbstractJackson2Decoder {
    private static final MimeType SMILE_MIME_TYPE = new MediaType("application", "x-jackson-smile");

    public Jackson2SmileDecoder() {
        this((ObjectMapper)Jackson2ObjectMapperBuilder.smile().build(), SMILE_MIME_TYPE);
    }

    public Jackson2SmileDecoder(ObjectMapper mapper, MimeType ... mimeTypes) {
        super(mapper, mimeTypes);
        Assert.isAssignable(SmileFactory.class, mapper.getFactory().getClass());
    }

    public List<MimeType> getDecodableMimeTypes() {
        return Collections.singletonList(SMILE_MIME_TYPE);
    }
}

