/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.SimpleLocaleContext;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.i18n.LocaleContextResolver;

public class AcceptHeaderLocaleContextResolver
implements LocaleContextResolver {
    private final List<Locale> supportedLocales = new ArrayList<Locale>(4);
    @Nullable
    private Locale defaultLocale;

    public void setSupportedLocales(@Nullable List<Locale> locales) {
        this.supportedLocales.clear();
        if (locales != null) {
            this.supportedLocales.addAll(locales);
        }
    }

    public List<Locale> getSupportedLocales() {
        return this.supportedLocales;
    }

    public void setDefaultLocale(@Nullable Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    @Nullable
    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    @Override
    public LocaleContext resolveLocaleContext(ServerWebExchange exchange2) {
        Locale requestLocale;
        ServerHttpRequest request = exchange2.getRequest();
        List<Locale> acceptableLocales = request.getHeaders().getAcceptLanguageAsLocales();
        if (this.defaultLocale != null && acceptableLocales.isEmpty()) {
            return new SimpleLocaleContext(this.defaultLocale);
        }
        Locale locale = requestLocale = acceptableLocales.isEmpty() ? null : acceptableLocales.get(0);
        if (this.isSupportedLocale(requestLocale)) {
            return new SimpleLocaleContext(requestLocale);
        }
        Locale supportedLocale = this.findSupportedLocale(request);
        if (supportedLocale != null) {
            return new SimpleLocaleContext(supportedLocale);
        }
        return this.defaultLocale != null ? new SimpleLocaleContext(this.defaultLocale) : new SimpleLocaleContext(requestLocale);
    }

    private boolean isSupportedLocale(@Nullable Locale locale) {
        if (locale == null) {
            return false;
        }
        List<Locale> supportedLocales = this.getSupportedLocales();
        return supportedLocales.isEmpty() || supportedLocales.contains(locale);
    }

    @Nullable
    private Locale findSupportedLocale(ServerHttpRequest request) {
        List<Locale> requestLocales = request.getHeaders().getAcceptLanguageAsLocales();
        for (Locale locale : requestLocales) {
            if (!this.getSupportedLocales().contains(locale)) continue;
            return locale;
        }
        return null;
    }

    @Override
    public void setLocaleContext(ServerWebExchange exchange2, @Nullable LocaleContext locale) {
        throw new UnsupportedOperationException("Cannot change HTTP accept header - use a different locale context resolution strategy");
    }
}

