/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.json;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractMapAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.Failures;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.test.http.HttpMessageContentConverter;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractJsonValueAssert<SELF extends AbstractJsonValueAssert<SELF>>
extends AbstractObjectAssert<SELF, Object> {
    private final Failures failures = Failures.instance();
    @Nullable
    private final HttpMessageContentConverter contentConverter;

    protected AbstractJsonValueAssert(@Nullable Object actual, Class<?> selfType, @Nullable HttpMessageContentConverter contentConverter) {
        super(actual, selfType);
        this.contentConverter = contentConverter;
    }

    public AbstractStringAssert<?> asString() {
        return Assertions.assertThat((String)this.castTo(String.class, "a string"));
    }

    public AbstractObjectAssert<?, Number> asNumber() {
        return Assertions.assertThat((Object)this.castTo(Number.class, "a number"));
    }

    public AbstractBooleanAssert<?> asBoolean() {
        return Assertions.assertThat((Boolean)this.castTo(Boolean.class, "a boolean"));
    }

    public ObjectArrayAssert<Object> asArray() {
        List list = this.castTo(List.class, "an array");
        Object[] array = list.toArray(new Object[0]);
        return Assertions.assertThat((Object[])array);
    }

    public AbstractMapAssert<?, Map<String, Object>, String, Object> asMap() {
        return Assertions.assertThat((Map)this.castTo(Map.class, "a map"));
    }

    private <T> T castTo(Class<T> expectedType, String description) {
        if (this.actual == null) {
            throw this.valueProcessingFailed("To be %s%n".formatted(description));
        }
        if (!expectedType.isInstance(this.actual)) {
            throw this.valueProcessingFailed("To be %s%nBut was:%n  %s%n".formatted(description, this.actual.getClass().getName()));
        }
        return expectedType.cast(this.actual);
    }

    public <T> AbstractObjectAssert<?, T> convertTo(Class<T> target) {
        this.isNotNull();
        T value = this.convertToTargetType(target);
        return Assertions.assertThat(value);
    }

    public <ASSERT extends AbstractAssert<?, ?>> ASSERT convertTo(AssertFactory<?, ASSERT> assertFactory) {
        this.isNotNull();
        return (ASSERT)((AbstractAssert)assertFactory.createAssert(this::convertToTargetType));
    }

    public SELF isEmpty() {
        if (!ObjectUtils.isEmpty((Object)this.actual)) {
            throw this.valueProcessingFailed("To be empty");
        }
        return (SELF)((Object)((AbstractJsonValueAssert)this.myself));
    }

    public SELF isNotEmpty() {
        if (ObjectUtils.isEmpty((Object)this.actual)) {
            throw this.valueProcessingFailed("To not be empty");
        }
        return (SELF)((Object)((AbstractJsonValueAssert)this.myself));
    }

    private <T> T convertToTargetType(Type targetType) {
        if (this.contentConverter == null) {
            throw new IllegalStateException("No JSON message converter available to convert %s".formatted(this.actualToString()));
        }
        try {
            return this.contentConverter.convertViaJson(this.actual, ResolvableType.forType((Type)targetType));
        }
        catch (Exception ex) {
            throw this.valueProcessingFailed("To convert successfully to:%n  %s%nBut it failed:%n  %s%n".formatted(targetType.getTypeName(), ex.getMessage()));
        }
    }

    protected String getExpectedErrorMessagePrefix() {
        return "Expected:";
    }

    private AssertionError valueProcessingFailed(String errorMessage) {
        throw this.failures.failure((AssertionInfo)this.info, (ErrorMessageFactory)new ValueProcessingFailed(this.getExpectedErrorMessagePrefix(), this.actualToString(), errorMessage));
    }

    private String actualToString() {
        return ObjectUtils.nullSafeToString((Object)StringUtils.quoteIfString((Object)this.actual));
    }

    private static final class ValueProcessingFailed
    extends BasicErrorMessageFactory {
        private ValueProcessingFailed(String prefix, String actualToString, String errorMessage) {
            super("%n%s%n  %s%n%s".formatted(prefix, actualToString, errorMessage), new Object[0]);
        }
    }
}

