/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.assertj;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.springframework.util.function.SingletonSupplier;

public abstract class AbstractHttpServletRequestAssert<SELF extends AbstractHttpServletRequestAssert<SELF, ACTUAL>, ACTUAL extends HttpServletRequest>
extends AbstractObjectAssert<SELF, ACTUAL> {
    private final Supplier<MapAssert<String, Object>> attributesAssertProvider = SingletonSupplier.of(() -> AbstractHttpServletRequestAssert.createAttributesAssert(actual));
    private final Supplier<MapAssert<String, Object>> sessionAttributesAssertProvider = SingletonSupplier.of(() -> AbstractHttpServletRequestAssert.createSessionAttributesAssert(actual));

    protected AbstractHttpServletRequestAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    private static MapAssert<String, Object> createAttributesAssert(HttpServletRequest request2) {
        Map<String, Object> map = AbstractHttpServletRequestAssert.toMap(request2.getAttributeNames(), arg_0 -> ((HttpServletRequest)request2).getAttribute(arg_0));
        return (MapAssert)Assertions.assertThat(map).as("Request Attributes", new Object[0]);
    }

    private static MapAssert<String, Object> createSessionAttributesAssert(HttpServletRequest request2) {
        HttpSession session = request2.getSession();
        ((ObjectAssert)Assertions.assertThat((Object)session).as("HTTP session", new Object[0])).isNotNull();
        Map<String, Object> map = AbstractHttpServletRequestAssert.toMap(session.getAttributeNames(), arg_0 -> ((HttpSession)session).getAttribute(arg_0));
        return (MapAssert)Assertions.assertThat(map).as("Session Attributes", new Object[0]);
    }

    public MapAssert<String, Object> attributes() {
        return this.attributesAssertProvider.get();
    }

    public MapAssert<String, Object> sessionAttributes() {
        return this.sessionAttributesAssertProvider.get();
    }

    public SELF hasAsyncStarted(boolean started) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((HttpServletRequest)this.actual).isAsyncStarted()).withFailMessage("Async expected %s have started", new Object[]{started ? "to" : "not to"})).isEqualTo(started);
        return (SELF)((Object)((AbstractHttpServletRequestAssert)this.myself));
    }

    private static Map<String, Object> toMap(Enumeration<String> keys, Function<String, Object> valueProvider) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            map.put(key, valueProvider.apply(key));
        }
        return map;
    }
}

