/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.test.context.bean.override.BeanOverrideHandler;
import org.springframework.test.context.bean.override.BeanOverrideStrategy;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

class BeanOverrideRegistry {
    private static final Log logger = LogFactory.getLog(BeanOverrideRegistry.class);
    private final Map<BeanOverrideHandler, String> handlerToBeanNameMap = new LinkedHashMap<BeanOverrideHandler, String>();
    private final Map<String, BeanOverrideHandler> wrappingBeanOverrideHandlers = new LinkedHashMap<String, BeanOverrideHandler>();
    private final ConfigurableBeanFactory beanFactory;

    BeanOverrideRegistry(ConfigurableBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"ConfigurableBeanFactory must not be null");
        this.beanFactory = beanFactory;
    }

    void registerBeanOverrideHandler(BeanOverrideHandler handler, String beanName) {
        Assert.state((!this.handlerToBeanNameMap.containsKey(handler) ? 1 : 0) != 0, () -> "Cannot register BeanOverrideHandler for bean with name '%s'; detected multiple registrations for %s".formatted(beanName, handler));
        boolean beanNameAlreadyRegistered = this.handlerToBeanNameMap.containsValue(beanName);
        this.handlerToBeanNameMap.put(handler, beanName);
        if (beanNameAlreadyRegistered && logger.isWarnEnabled()) {
            List<BeanOverrideHandler> competingHandlers = this.handlerToBeanNameMap.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(beanName)).map(Map.Entry::getKey).toList();
            logger.warn((Object)"Bean with name '%s' was overridden by multiple handlers: %s".formatted(beanName, competingHandlers));
        }
        if (handler.getStrategy() == BeanOverrideStrategy.WRAP) {
            this.wrappingBeanOverrideHandlers.put(beanName, handler);
        }
    }

    Object wrapBeanIfNecessary(Object bean, String beanName) {
        if (!this.wrappingBeanOverrideHandlers.containsKey(beanName)) {
            return bean;
        }
        BeanOverrideHandler handler = this.wrappingBeanOverrideHandlers.get(beanName);
        Assert.state((handler != null ? 1 : 0) != 0, () -> "Failed to find wrapping BeanOverrideHandler for bean '" + beanName + "'");
        return handler.createOverrideInstance(beanName, null, bean, (SingletonBeanRegistry)this.beanFactory);
    }

    void inject(Object target, BeanOverrideHandler handler) {
        Field field = handler.getField();
        Assert.notNull((Object)field, () -> "BeanOverrideHandler must have a non-null field: " + handler);
        String beanName = this.handlerToBeanNameMap.get(handler);
        Assert.state((boolean)StringUtils.hasLength((String)beanName), () -> "No bean found for BeanOverrideHandler: " + handler);
        this.inject(field, target, beanName);
    }

    private void inject(Field field, Object target, String beanName) {
        try {
            Object bean = this.beanFactory.getBean(beanName, field.getType());
            ReflectionUtils.makeAccessible((Field)field);
            ReflectionUtils.setField((Field)field, (Object)target, (Object)bean);
        }
        catch (Throwable ex) {
            throw new BeanCreationException("Could not inject field '" + field + "'", ex);
        }
    }
}

