/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket.service;

import java.lang.reflect.Type;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.rsocket.service.RSocketRequestValues;
import org.springframework.messaging.rsocket.service.RSocketServiceArgumentResolver;
import org.springframework.util.Assert;

public class PayloadArgumentResolver
implements RSocketServiceArgumentResolver {
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;
    private final boolean useDefaultResolution;

    public PayloadArgumentResolver(ReactiveAdapterRegistry reactiveAdapterRegistry, boolean useDefaultResolution) {
        this.useDefaultResolution = useDefaultResolution;
        Assert.notNull((Object)reactiveAdapterRegistry, (String)"ReactiveAdapterRegistry is required");
        this.reactiveAdapterRegistry = reactiveAdapterRegistry;
    }

    @Override
    public boolean resolve(@Nullable Object argument, MethodParameter parameter, RSocketRequestValues.Builder requestValues) {
        Payload annot = (Payload)parameter.getParameterAnnotation(Payload.class);
        if (annot == null && !this.useDefaultResolution) {
            return false;
        }
        if (argument == null) {
            boolean isOptional = annot != null && !annot.required() || parameter.isOptional();
            Assert.isTrue((boolean)isOptional, () -> "Missing payload");
            return true;
        }
        ReactiveAdapter adapter = this.reactiveAdapterRegistry.getAdapter(parameter.getParameterType());
        if (adapter == null) {
            requestValues.setPayloadValue(argument);
        } else {
            MethodParameter nestedParameter = parameter.nested();
            String message = "Async type for @Payload should produce value(s)";
            Assert.isTrue((nestedParameter.getNestedParameterType() != Void.class ? 1 : 0) != 0, (String)message);
            Assert.isTrue((!adapter.isNoValue() ? 1 : 0) != 0, (String)message);
            requestValues.setPayload(adapter.toPublisher(argument), ParameterizedTypeReference.forType((Type)nestedParameter.getNestedGenericParameterType()));
        }
        return true;
    }
}

