/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.support;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class NoOpCacheManager
implements CacheManager {
    private final ConcurrentMap<String, Cache> caches = new ConcurrentHashMap<String, Cache>(16);
    private final Set<String> cacheNames = new LinkedHashSet<String>(16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache getCache(String name) {
        Cache cache = (Cache)this.caches.get(name);
        if (cache == null) {
            this.caches.putIfAbsent(name, new NoOpCache(name));
            Set<String> set = this.cacheNames;
            synchronized (set) {
                this.cacheNames.add(name);
            }
        }
        return (Cache)this.caches.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getCacheNames() {
        Set<String> set = this.cacheNames;
        synchronized (set) {
            return Collections.unmodifiableSet(this.cacheNames);
        }
    }

    private static class NoOpCache
    implements Cache {
        private final String name;

        public NoOpCache(String name) {
            this.name = name;
        }

        @Override
        public void clear() {
        }

        @Override
        public void evict(Object key) {
        }

        @Override
        public Cache.ValueWrapper get(Object key) {
            return null;
        }

        @Override
        public <T> T get(Object key, Class<T> type) {
            return null;
        }

        @Override
        public <T> T get(Object key, Callable<T> valueLoader) {
            try {
                return valueLoader.call();
            }
            catch (Exception ex) {
                throw new Cache.ValueRetrievalException(key, valueLoader, ex);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getNativeCache() {
            return null;
        }

        @Override
        public void put(Object key, Object value) {
        }

        @Override
        public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
            return null;
        }
    }
}

