/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.transaction;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.cache.Cache;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class TransactionAwareCacheDecorator
implements Cache {
    private final Cache targetCache;

    public TransactionAwareCacheDecorator(Cache targetCache) {
        Assert.notNull((Object)targetCache, (String)"Target Cache must not be null");
        this.targetCache = targetCache;
    }

    public Cache getTargetCache() {
        return this.targetCache;
    }

    public String getName() {
        return this.targetCache.getName();
    }

    public Object getNativeCache() {
        return this.targetCache.getNativeCache();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Cache.ValueWrapper get(Object key) {
        return this.targetCache.get(key);
    }

    public <T> @Nullable T get(Object key, @Nullable Class<T> type) {
        return (T)this.targetCache.get(key, type);
    }

    public <T> @Nullable T get(Object key, Callable<T> valueLoader) {
        return (T)this.targetCache.get(key, valueLoader);
    }

    public @Nullable CompletableFuture<?> retrieve(Object key) {
        return this.targetCache.retrieve(key);
    }

    public <T> CompletableFuture<T> retrieve(Object key, Supplier<CompletableFuture<T>> valueLoader) {
        return this.targetCache.retrieve(key, valueLoader);
    }

    public void put(final Object key, final @Nullable Object value) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){
                final /* synthetic */ TransactionAwareCacheDecorator this$0;
                {
                    this.this$0 = this$0;
                }

                public void afterCommit() {
                    this.this$0.targetCache.put(key, value);
                }
            });
        } else {
            this.targetCache.put(key, value);
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Cache.ValueWrapper putIfAbsent(Object key, @Nullable Object value) {
        return this.targetCache.putIfAbsent(key, value);
    }

    public void evict(final Object key) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){
                final /* synthetic */ TransactionAwareCacheDecorator this$0;
                {
                    this.this$0 = this$0;
                }

                public void afterCommit() {
                    this.this$0.targetCache.evict(key);
                }
            });
        } else {
            this.targetCache.evict(key);
        }
    }

    public boolean evictIfPresent(Object key) {
        return this.targetCache.evictIfPresent(key);
    }

    public void clear() {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    TransactionAwareCacheDecorator.this.targetCache.clear();
                }
            });
        } else {
            this.targetCache.clear();
        }
    }

    public boolean invalidate() {
        return this.targetCache.invalidate();
    }
}

