/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TwitterEscapingFormHttpMessageConverter
extends FormHttpMessageConverter {
    TwitterEscapingFormHttpMessageConverter() {
    }

    public void write(MultiValueMap<String, ?> map, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (!this.isMultipart(map, contentType)) {
            super.write(map, contentType, (HttpOutputMessage)new TwitterEscapingHttpOutputMessage(outputMessage));
        } else {
            super.write(map, contentType, outputMessage);
        }
    }

    private boolean isMultipart(MultiValueMap<String, ?> map, MediaType contentType) {
        if (contentType != null) {
            return MediaType.MULTIPART_FORM_DATA.equals((Object)contentType);
        }
        for (String name : map.keySet()) {
            for (Object value : (List)map.get((Object)name)) {
                if (value == null || value instanceof String) continue;
                return true;
            }
        }
        return false;
    }

    private static class TwitterEscapingOutputStream
    extends OutputStream {
        private OutputStream target;

        public TwitterEscapingOutputStream(OutputStream target) {
            this.target = target;
        }

        public void write(int b) throws IOException {
            if (b == 42) {
                this.target.write(37);
                this.target.write(50);
                this.target.write(65);
            } else {
                this.target.write(b);
            }
        }
    }

    private static class TwitterEscapingHttpOutputMessage
    implements HttpOutputMessage {
        private HttpOutputMessage target;

        public TwitterEscapingHttpOutputMessage(HttpOutputMessage target) {
            this.target = target;
        }

        public HttpHeaders getHeaders() {
            return this.target.getHeaders();
        }

        public OutputStream getBody() throws IOException {
            return new TwitterEscapingOutputStream(this.target.getBody());
        }
    }
}

