/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.text.SimpleDateFormat;
import org.springframework.social.twitter.api.SearchParameters;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SearchParametersUtil {
    public static final int DEFAULT_RESULTS_PER_PAGE = 50;

    SearchParametersUtil() {
    }

    public static MultiValueMap<String, String> buildQueryParametersFromSearchParameters(SearchParameters searchParameters) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"q", (Object)searchParameters.getQuery());
        if (searchParameters.getGeoCode() != null) {
            parameters.set((Object)"geocode", (Object)searchParameters.getGeoCode().toString());
        }
        if (searchParameters.getLang() != null) {
            parameters.set((Object)"lang", (Object)searchParameters.getLang());
        }
        if (searchParameters.getLocale() != null) {
            parameters.set((Object)"locale", (Object)searchParameters.getLocale());
        }
        if (searchParameters.getResultType() != null) {
            parameters.set((Object)"result_type", (Object)searchParameters.getResultType().toString());
        }
        parameters.set((Object)"count", (Object)(searchParameters.getCount() != null ? String.valueOf(searchParameters.getCount()) : String.valueOf(50)));
        if (searchParameters.getUntil() != null) {
            parameters.set((Object)"until", (Object)new SimpleDateFormat("yyyy-MM-dd").format(searchParameters.getUntil()));
        }
        if (searchParameters.getSinceId() != null) {
            parameters.set((Object)"since_id", (Object)String.valueOf(searchParameters.getSinceId()));
        }
        if (searchParameters.getMaxId() != null) {
            parameters.set((Object)"max_id", (Object)String.valueOf(searchParameters.getMaxId()));
        }
        if (!searchParameters.isIncludeEntities()) {
            parameters.set((Object)"include_entities", (Object)"false");
        }
        return parameters;
    }
}

