/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.social.twitter.api.ImageSize;
import org.springframework.social.twitter.api.RateLimitStatus;
import org.springframework.social.twitter.api.SuggestionCategory;
import org.springframework.social.twitter.api.TwitterProfile;
import org.springframework.social.twitter.api.UserOperations;
import org.springframework.social.twitter.api.impl.AbstractTwitterOperations;
import org.springframework.social.twitter.api.impl.ArrayUtils;
import org.springframework.social.twitter.api.impl.PagingUtils;
import org.springframework.social.twitter.api.impl.SuggestionCategoryList;
import org.springframework.social.twitter.api.impl.TwitterProfileList;
import org.springframework.social.twitter.api.impl.TwitterProfileUsersList;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UserTemplate
extends AbstractTwitterOperations
implements UserOperations {
    private final RestTemplate restTemplate;

    public UserTemplate(RestTemplate restTemplate, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.restTemplate = restTemplate;
    }

    @Override
    public long getProfileId() {
        this.requireAuthorization();
        return this.getUserProfile().getId();
    }

    @Override
    public String getScreenName() {
        this.requireAuthorization();
        return this.getUserProfile().getScreenName();
    }

    @Override
    public TwitterProfile getUserProfile() {
        this.requireAuthorization();
        return (TwitterProfile)this.restTemplate.getForObject(this.buildUri("account/verify_credentials.json"), TwitterProfile.class);
    }

    @Override
    public TwitterProfile getUserProfile(String screenName) {
        return (TwitterProfile)this.restTemplate.getForObject(this.buildUri("users/show.json", "screen_name", screenName), TwitterProfile.class);
    }

    @Override
    public TwitterProfile getUserProfile(long userId) {
        return (TwitterProfile)this.restTemplate.getForObject(this.buildUri("users/show.json", "user_id", String.valueOf(userId)), TwitterProfile.class);
    }

    @Override
    public byte[] getUserProfileImage(String screenName) {
        return this.getUserProfileImage(screenName, ImageSize.NORMAL);
    }

    @Override
    public byte[] getUserProfileImage(String screenName, ImageSize size) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"size", (Object)size.toString().toLowerCase());
        ResponseEntity response = this.restTemplate.getForEntity(this.buildUri("users/profile_image/" + screenName, (MultiValueMap<String, String>)parameters), byte[].class);
        if (response.getStatusCode() == HttpStatus.FOUND) {
            throw new UnsupportedOperationException("Attempt to fetch image resulted in a redirect which could not be followed. Add Apache HttpComponents HttpClient to the classpath to be able to follow redirects.");
        }
        return (byte[])response.getBody();
    }

    @Override
    public List<TwitterProfile> getUsers(long ... userIds) {
        String joinedIds = ArrayUtils.join(userIds);
        return (List)this.restTemplate.getForObject(this.buildUri("users/lookup.json", "user_id", joinedIds), TwitterProfileList.class);
    }

    @Override
    public List<TwitterProfile> getUsers(String ... screenNames) {
        String joinedScreenNames = ArrayUtils.join(screenNames);
        return (List)this.restTemplate.getForObject(this.buildUri("users/lookup.json", "screen_name", joinedScreenNames), TwitterProfileList.class);
    }

    @Override
    public List<TwitterProfile> searchForUsers(String query) {
        return this.searchForUsers(query, 1, 20);
    }

    @Override
    public List<TwitterProfile> searchForUsers(String query, int page, int pageSize) {
        this.requireAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithPerPage(page, pageSize, 0L, 0L);
        parameters.set((Object)"q", (Object)query);
        return (List)this.restTemplate.getForObject(this.buildUri("users/search.json", parameters), TwitterProfileList.class);
    }

    @Override
    public List<SuggestionCategory> getSuggestionCategories() {
        return (List)this.restTemplate.getForObject(this.buildUri("users/suggestions.json"), SuggestionCategoryList.class);
    }

    @Override
    public List<TwitterProfile> getSuggestions(String slug) {
        return ((TwitterProfileUsersList)this.restTemplate.getForObject(this.buildUri("users/suggestions/" + slug + ".json"), TwitterProfileUsersList.class)).getList();
    }

    @Override
    public RateLimitStatus getRateLimitStatus() {
        return (RateLimitStatus)this.restTemplate.getForObject(this.buildUri("account/rate_limit_status.json"), RateLimitStatus.class);
    }
}

