/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.util.HashMap;
import java.util.List;
import org.springframework.social.twitter.api.SavedSearch;
import org.springframework.social.twitter.api.SearchOperations;
import org.springframework.social.twitter.api.SearchResults;
import org.springframework.social.twitter.api.Trends;
import org.springframework.social.twitter.api.impl.AbstractTwitterOperations;
import org.springframework.social.twitter.api.impl.DailyTrendsList;
import org.springframework.social.twitter.api.impl.LocalTrendsHolder;
import org.springframework.social.twitter.api.impl.SavedSearchList;
import org.springframework.social.twitter.api.impl.WeeklyTrendsList;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SearchTemplate
extends AbstractTwitterOperations
implements SearchOperations {
    private final RestTemplate restTemplate;
    static final int DEFAULT_RESULTS_PER_PAGE = 50;
    private static final String SEARCH_API_URL_BASE = "https://search.twitter.com";
    private static final String SEARCH_URL = "https://search.twitter.com/search.json?q={query}&rpp={rpp}&page={page}";

    public SearchTemplate(RestTemplate restTemplate, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.restTemplate = restTemplate;
    }

    @Override
    public SearchResults search(String query) {
        return this.search(query, 1, 50, 0L, 0L);
    }

    @Override
    public SearchResults search(String query, int page, int resultsPerPage) {
        return this.search(query, page, resultsPerPage, 0L, 0L);
    }

    @Override
    public SearchResults search(String query, int page, int resultsPerPage, long sinceId, long maxId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("query", query);
        parameters.put("rpp", String.valueOf(resultsPerPage));
        parameters.put("page", String.valueOf(page));
        String searchUrl = SEARCH_URL;
        if (sinceId > 0L) {
            searchUrl = searchUrl + "&since_id={since}";
            parameters.put("since", String.valueOf(sinceId));
        }
        if (maxId > 0L) {
            searchUrl = searchUrl + "&max_id={max}";
            parameters.put("max", String.valueOf(maxId));
        }
        return (SearchResults)this.restTemplate.getForObject(searchUrl, SearchResults.class, parameters);
    }

    @Override
    public List<SavedSearch> getSavedSearches() {
        this.requireAuthorization();
        return (List)this.restTemplate.getForObject(this.buildUri("saved_searches.json"), SavedSearchList.class);
    }

    @Override
    public SavedSearch getSavedSearch(long searchId) {
        this.requireAuthorization();
        return (SavedSearch)this.restTemplate.getForObject(this.buildUri("saved_searches/show/" + searchId + ".json"), SavedSearch.class);
    }

    @Override
    public SavedSearch createSavedSearch(String query) {
        this.requireAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.set((Object)"query", (Object)query);
        return (SavedSearch)this.restTemplate.postForObject(this.buildUri("saved_searches/create.json"), (Object)data, SavedSearch.class);
    }

    @Override
    public void deleteSavedSearch(long searchId) {
        this.requireAuthorization();
        this.restTemplate.delete(this.buildUri("saved_searches/destroy/" + searchId + ".json"));
    }

    @Override
    public List<Trends> getDailyTrends() {
        return this.getDailyTrends(false, null);
    }

    @Override
    public List<Trends> getDailyTrends(boolean excludeHashtags) {
        return this.getDailyTrends(excludeHashtags, null);
    }

    @Override
    public List<Trends> getDailyTrends(boolean excludeHashtags, String startDate) {
        String path = this.makeTrendPath("trends/daily.json", excludeHashtags, startDate);
        return ((DailyTrendsList)this.restTemplate.getForObject(this.buildUri(path), DailyTrendsList.class)).getList();
    }

    @Override
    public List<Trends> getWeeklyTrends() {
        return this.getWeeklyTrends(false, null);
    }

    @Override
    public List<Trends> getWeeklyTrends(boolean excludeHashtags) {
        return this.getWeeklyTrends(excludeHashtags, null);
    }

    @Override
    public List<Trends> getWeeklyTrends(boolean excludeHashtags, String startDate) {
        String path = this.makeTrendPath("trends/weekly.json", excludeHashtags, startDate);
        return ((WeeklyTrendsList)this.restTemplate.getForObject(this.buildUri(path), WeeklyTrendsList.class)).getList();
    }

    @Override
    public Trends getLocalTrends(long whereOnEarthId) {
        return this.getLocalTrends(whereOnEarthId, false);
    }

    @Override
    public Trends getLocalTrends(long whereOnEarthId, boolean excludeHashtags) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (excludeHashtags) {
            parameters.set((Object)"exclude", (Object)"hashtags");
        }
        return ((LocalTrendsHolder)this.restTemplate.getForObject(this.buildUri("trends/" + whereOnEarthId + ".json", (MultiValueMap<String, String>)parameters), LocalTrendsHolder.class)).getTrends();
    }

    private String makeTrendPath(String basePath, boolean excludeHashtags, String startDate) {
        String url = basePath + (excludeHashtags || startDate != null ? "?" : "");
        url = url + (excludeHashtags ? "exclude=hashtags" : "");
        url = url + (excludeHashtags && startDate != null ? "&" : "");
        url = url + (startDate != null ? "date=" + startDate : "");
        return url;
    }
}

