/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.web.access.DelegatingAccessDeniedHandler;
import org.springframework.security.web.csrf.CsrfAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfLogoutHandler;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.security.web.csrf.LazyCsrfTokenRepository;
import org.springframework.security.web.csrf.MissingCsrfTokenException;
import org.springframework.security.web.servlet.support.csrf.CsrfRequestDataValueProcessor;
import org.springframework.security.web.session.InvalidSessionAccessDeniedHandler;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class CsrfBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String REQUEST_DATA_VALUE_PROCESSOR = "requestDataValueProcessor";
    private static final String DISPATCHER_SERVLET_CLASS_NAME = "org.springframework.web.servlet.DispatcherServlet";
    private static final String ATT_MATCHER = "request-matcher-ref";
    private static final String ATT_REPOSITORY = "token-repository-ref";
    private String csrfRepositoryRef;
    private BeanDefinition csrfFilter;

    public BeanDefinition parse(Element element, ParserContext pc) {
        boolean disabled;
        boolean bl = disabled = element != null && "true".equals(element.getAttribute("disabled"));
        if (disabled) {
            return null;
        }
        boolean webmvcPresent = ClassUtils.isPresent((String)DISPATCHER_SERVLET_CLASS_NAME, (ClassLoader)this.getClass().getClassLoader());
        if (webmvcPresent && !pc.getRegistry().containsBeanDefinition(REQUEST_DATA_VALUE_PROCESSOR)) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(CsrfRequestDataValueProcessor.class);
            BeanComponentDefinition componentDefinition = new BeanComponentDefinition((BeanDefinition)beanDefinition, REQUEST_DATA_VALUE_PROCESSOR);
            pc.registerBeanComponent(componentDefinition);
        }
        String matcherRef = null;
        if (element != null) {
            this.csrfRepositoryRef = element.getAttribute(ATT_REPOSITORY);
            matcherRef = element.getAttribute(ATT_MATCHER);
        }
        if (!StringUtils.hasText((String)this.csrfRepositoryRef)) {
            RootBeanDefinition csrfTokenRepository = new RootBeanDefinition(HttpSessionCsrfTokenRepository.class);
            BeanDefinitionBuilder lazyTokenRepository = BeanDefinitionBuilder.rootBeanDefinition(LazyCsrfTokenRepository.class);
            lazyTokenRepository.addConstructorArgValue((Object)csrfTokenRepository);
            this.csrfRepositoryRef = pc.getReaderContext().generateBeanName((BeanDefinition)lazyTokenRepository.getBeanDefinition());
            pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)lazyTokenRepository.getBeanDefinition(), this.csrfRepositoryRef));
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(CsrfFilter.class);
        builder.addConstructorArgReference(this.csrfRepositoryRef);
        if (StringUtils.hasText((String)matcherRef)) {
            builder.addPropertyReference("requireCsrfProtectionMatcher", matcherRef);
        }
        this.csrfFilter = builder.getBeanDefinition();
        return this.csrfFilter;
    }

    void initAccessDeniedHandler(BeanDefinition invalidSessionStrategy, BeanMetadataElement defaultDeniedHandler) {
        BeanMetadataElement accessDeniedHandler = this.createAccessDeniedHandler(invalidSessionStrategy, defaultDeniedHandler);
        this.csrfFilter.getPropertyValues().addPropertyValue("accessDeniedHandler", (Object)accessDeniedHandler);
    }

    private BeanMetadataElement createAccessDeniedHandler(BeanDefinition invalidSessionStrategy, BeanMetadataElement defaultDeniedHandler) {
        if (invalidSessionStrategy == null) {
            return defaultDeniedHandler;
        }
        ManagedMap handlers = new ManagedMap();
        BeanDefinitionBuilder invalidSessionHandlerBldr = BeanDefinitionBuilder.rootBeanDefinition(InvalidSessionAccessDeniedHandler.class);
        invalidSessionHandlerBldr.addConstructorArgValue((Object)invalidSessionStrategy);
        handlers.put(MissingCsrfTokenException.class, (Object)invalidSessionHandlerBldr.getBeanDefinition());
        BeanDefinitionBuilder deniedBldr = BeanDefinitionBuilder.rootBeanDefinition(DelegatingAccessDeniedHandler.class);
        deniedBldr.addConstructorArgValue((Object)handlers);
        deniedBldr.addConstructorArgValue((Object)defaultDeniedHandler);
        return deniedBldr.getBeanDefinition();
    }

    BeanDefinition getCsrfAuthenticationStrategy() {
        BeanDefinitionBuilder csrfAuthenticationStrategy = BeanDefinitionBuilder.rootBeanDefinition(CsrfAuthenticationStrategy.class);
        csrfAuthenticationStrategy.addConstructorArgReference(this.csrfRepositoryRef);
        return csrfAuthenticationStrategy.getBeanDefinition();
    }

    BeanDefinition getCsrfLogoutHandler() {
        BeanDefinitionBuilder csrfAuthenticationStrategy = BeanDefinitionBuilder.rootBeanDefinition(CsrfLogoutHandler.class);
        csrfAuthenticationStrategy.addConstructorArgReference(this.csrfRepositoryRef);
        return csrfAuthenticationStrategy.getBeanDefinition();
    }
}

