/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.pdx;

import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.geode.pdx.PdxFieldDoesNotExistException;
import org.apache.geode.pdx.PdxFieldTypeMismatchException;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.WritablePdxInstance;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.geode.pdx.PdxFieldNotWritableException;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ObjectPdxInstanceAdapter
implements PdxInstance {
    protected static final String CLASS_PROPERTY_NAME = "class";
    protected static final String ID_PROPERTY_NAME = "id";
    private final AtomicReference<String> resolvedIdentityFieldName = new AtomicReference<Object>(null);
    private final transient BeanWrapper beanWrapper;
    private final Object target;

    private static void assertCondition(boolean condition, Supplier<RuntimeException> runtimeExceptionSupplier) {
        if (!condition) {
            throw runtimeExceptionSupplier.get();
        }
    }

    public static ObjectPdxInstanceAdapter from(@NonNull Object target) {
        return new ObjectPdxInstanceAdapter(target);
    }

    @Nullable
    public static Object unwrap(@Nullable PdxInstance pdxInstance) {
        return pdxInstance instanceof ObjectPdxInstanceAdapter ? pdxInstance.getObject() : pdxInstance;
    }

    public ObjectPdxInstanceAdapter(Object target) {
        Assert.notNull((Object)target, (String)"Object to adapt must not be null");
        this.target = target;
        this.beanWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)target);
    }

    @NonNull
    protected BeanWrapper getBeanWrapper() {
        return this.beanWrapper;
    }

    public String getClassName() {
        return this.getObject().getClass().getName();
    }

    public boolean isDeserializable() {
        return this.getObject() != null;
    }

    public boolean isEnum() {
        return this.getObject().getClass().isEnum();
    }

    public Object getField(String fieldName) {
        BeanWrapper beanWrapper = this.getBeanWrapper();
        return beanWrapper.isReadableProperty(fieldName) ? beanWrapper.getPropertyValue(fieldName) : null;
    }

    public List<String> getFieldNames() {
        PropertyDescriptor[] propertyDescriptors = (PropertyDescriptor[])ArrayUtils.nullSafeArray((Object[])this.getBeanWrapper().getPropertyDescriptors(), PropertyDescriptor.class);
        return Arrays.stream(propertyDescriptors).map(FeatureDescriptor::getName).filter(propertyName -> !CLASS_PROPERTY_NAME.equals(propertyName)).collect(Collectors.toList());
    }

    public boolean isIdentityField(String fieldName) {
        String resolvedIdentityFieldName = this.resolvedIdentityFieldName.updateAndGet(it -> StringUtils.hasText((String)it) ? it : this.resolveIdentityFieldNameFromProperty());
        return StringUtils.hasText((String)resolvedIdentityFieldName) && resolvedIdentityFieldName.equals(fieldName);
    }

    @Nullable
    String resolveIdentityFieldNameFromProperty() {
        return this.resolveIdentityFieldNameFromProperty(this.getBeanWrapper());
    }

    @Nullable
    private String resolveIdentityFieldNameFromProperty(@NonNull BeanWrapper beanWrapper) {
        List<Object> properties = Arrays.asList(ArrayUtils.nullSafeArray((Object[])beanWrapper.getPropertyDescriptors(), PropertyDescriptor.class));
        Optional<PropertyDescriptor> atIdAnnotatedProperty = properties.stream().filter(this::isAtIdAnnotatedProperty).findFirst();
        return atIdAnnotatedProperty.map(FeatureDescriptor::getName).orElseGet(() -> this.resolveIdentityFieldNameFromField(beanWrapper));
    }

    private boolean isAtIdAnnotatedProperty(@Nullable PropertyDescriptor propertyDescriptor) {
        return Optional.ofNullable(propertyDescriptor).map(PropertyDescriptor::getReadMethod).map(method -> (Id)AnnotationUtils.findAnnotation((Method)method, Id.class)).isPresent();
    }

    @Nullable
    private String resolveIdentityFieldNameFromField(@NonNull BeanWrapper beanWrapper) {
        List<Object> fields = Arrays.asList(ArrayUtils.nullSafeArray((Object[])beanWrapper.getWrappedClass().getDeclaredFields(), Field.class));
        Optional<PropertyDescriptor> atIdAnnotatedProperty = fields.stream().map(field -> this.getPropertyForAtIdAnnotatedField(beanWrapper, (Field)field)).filter(Objects::nonNull).findFirst();
        return atIdAnnotatedProperty.map(FeatureDescriptor::getName).orElseGet(() -> beanWrapper.isReadableProperty(ID_PROPERTY_NAME) ? ID_PROPERTY_NAME : null);
    }

    @Nullable
    private PropertyDescriptor getPropertyForAtIdAnnotatedField(@NonNull BeanWrapper beanWrapper, @Nullable Field field) {
        return Optional.ofNullable(field).filter(it -> beanWrapper.isReadableProperty(it.getName())).filter(it -> Objects.nonNull(AnnotationUtils.findAnnotation((AnnotatedElement)it, Id.class))).map(it -> beanWrapper.getPropertyDescriptor(it.getName())).orElse(null);
    }

    public Object getObject() {
        return this.target;
    }

    ObjectPdxInstanceAdapter getParent() {
        return this;
    }

    public WritablePdxInstance createWriter() {
        return new WritablePdxInstance(){

            public void setField(String fieldName, Object value) {
                this.withPropertyAccessorFor(fieldName, value).setPropertyValue(fieldName, value);
            }

            private PropertyAccessor withPropertyAccessorFor(String fieldName, Object value) {
                this.assertFieldIsPresent(fieldName);
                BeanWrapper beanWrapper = ObjectPdxInstanceAdapter.this.getBeanWrapper();
                this.assertFieldIsWritable(beanWrapper, fieldName);
                this.assertValueIsTypeMatch(beanWrapper, fieldName, value);
                return beanWrapper;
            }

            private void assertFieldIsPresent(String fieldName) {
                Supplier<String> pdxFieldNotFoundExceptionMessageSupplier = () -> String.format("Field [%1$s] does not exist on Object [%2$s]", fieldName, this.getClassName());
                ObjectPdxInstanceAdapter.assertCondition(this.hasField(fieldName), () -> new PdxFieldDoesNotExistException((String)pdxFieldNotFoundExceptionMessageSupplier.get()));
            }

            private void assertFieldIsWritable(BeanWrapper beanWrapper, String fieldName) {
                Supplier<String> pdxFieldNotWritableExceptionMessageSupplier = () -> String.format("Field [%1$s] of Object [%2$s] is not writable", fieldName, this.getClassName());
                ObjectPdxInstanceAdapter.assertCondition(beanWrapper.isWritableProperty(fieldName), () -> new PdxFieldNotWritableException((String)pdxFieldNotWritableExceptionMessageSupplier.get()));
            }

            private void assertValueIsTypeMatch(BeanWrapper beanWrapper, String fieldName, Object value) {
                PropertyDescriptor property = beanWrapper.getPropertyDescriptor(fieldName);
                Supplier<String> typeMismatchExceptionMessageSupplier = () -> String.format("Value [%1$s] of type [%2$s] does not match field [%3$s] of type [%4$s] on Object [%5$s]", value, ObjectUtils.nullSafeClassName((Object)value), fieldName, property.getPropertyType().getName(), this.getClassName());
                ObjectPdxInstanceAdapter.assertCondition(this.isTypeMatch(property, value), () -> new PdxFieldTypeMismatchException((String)typeMismatchExceptionMessageSupplier.get()));
            }

            private boolean isTypeMatch(PropertyDescriptor property, Object value) {
                return value == null || property.getPropertyType().isInstance(value);
            }

            public String getClassName() {
                return ObjectPdxInstanceAdapter.this.getParent().getClassName();
            }

            public boolean isDeserializable() {
                return ObjectPdxInstanceAdapter.this.getParent().isDeserializable();
            }

            public boolean isEnum() {
                return ObjectPdxInstanceAdapter.this.getParent().isEnum();
            }

            public Object getField(String fieldName) {
                return ObjectPdxInstanceAdapter.this.getParent().getField(fieldName);
            }

            public List<String> getFieldNames() {
                return ObjectPdxInstanceAdapter.this.getParent().getFieldNames();
            }

            public boolean isIdentityField(String fieldName) {
                return ObjectPdxInstanceAdapter.this.getParent().isIdentityField(fieldName);
            }

            public Object getObject() {
                return ObjectPdxInstanceAdapter.this.getParent().getObject();
            }

            public WritablePdxInstance createWriter() {
                return this;
            }

            public boolean hasField(String fieldName) {
                return ObjectPdxInstanceAdapter.this.getParent().hasField(fieldName);
            }
        };
    }

    public boolean hasField(String fieldName) {
        return this.getFieldNames().contains(fieldName);
    }
}

