/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.data.support;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.cache.Region;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.gemfire.support.SmartLifecycleSupport;
import org.springframework.geode.core.io.ResourceReader;
import org.springframework.geode.core.io.ResourceWriter;
import org.springframework.geode.data.CacheDataImporterExporter;
import org.springframework.geode.data.support.ResourceCapableCacheDataImporterExporter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class LifecycleAwareCacheDataImporterExporter
implements CacheDataImporterExporter,
ApplicationContextAware,
EnvironmentAware,
InitializingBean,
ResourceLoaderAware,
SmartLifecycleSupport {
    protected static final int DEFAULT_IMPORT_PHASE = -2146483648;
    protected static final String CACHE_DATA_IMPORT_LIFECYCLE_PROPERTY_NAME = "spring.boot.data.gemfire.cache.data.import.lifecycle";
    protected static final String CACHE_DATA_IMPORT_PHASE_PROPERTY_NAME = "spring.boot.data.gemfire.cache.data.import.phase";
    private final AtomicReference<ImportLifecycle> resolvedImportLifecycle = new AtomicReference<Object>(null);
    private final AtomicReference<Integer> resolvedImportPhase = new AtomicReference<Object>(null);
    private final CacheDataImporterExporter importerExporter;
    private Environment environment;
    private final Set<Region> regionsForImport = Collections.synchronizedSet(new HashSet());

    public LifecycleAwareCacheDataImporterExporter(@NonNull CacheDataImporterExporter importerExporter) {
        Assert.notNull((Object)importerExporter, (String)"The CacheDataImporterExporter to decorate must not be null");
        this.importerExporter = importerExporter;
    }

    public void afterPropertiesSet() throws Exception {
        CacheDataImporterExporter importerExporter = this.getCacheDataImporterExporter();
        if (importerExporter instanceof InitializingBean) {
            ((InitializingBean)importerExporter).afterPropertiesSet();
        }
    }

    public void setApplicationContext(@Nullable ApplicationContext applicationContext) {
        CacheDataImporterExporter importerExporter;
        if (applicationContext != null && (importerExporter = this.getCacheDataImporterExporter()) instanceof ApplicationContextAware) {
            ((ApplicationContextAware)importerExporter).setApplicationContext(applicationContext);
        }
    }

    @NonNull
    protected CacheDataImporterExporter getCacheDataImporterExporter() {
        return this.importerExporter;
    }

    public void setEnvironment(@Nullable Environment environment) {
        CacheDataImporterExporter importerExporter;
        this.environment = environment;
        if (environment != null && (importerExporter = this.getCacheDataImporterExporter()) instanceof EnvironmentAware) {
            ((EnvironmentAware)importerExporter).setEnvironment(environment);
        }
    }

    protected Optional<Environment> getEnvironment() {
        return Optional.ofNullable(this.environment);
    }

    @Autowired(required=false)
    public void setExportResourceResolver(@Nullable ResourceCapableCacheDataImporterExporter.ExportResourceResolver exportResourceResolver) {
        CacheDataImporterExporter importerExporter;
        if (exportResourceResolver != null && (importerExporter = this.getCacheDataImporterExporter()) instanceof ResourceCapableCacheDataImporterExporter) {
            ((ResourceCapableCacheDataImporterExporter)importerExporter).setExportResourceResolver(exportResourceResolver);
        }
    }

    @Autowired(required=false)
    public void setImportResourceResolver(@Nullable ResourceCapableCacheDataImporterExporter.ImportResourceResolver importResourceResolver) {
        CacheDataImporterExporter importerExporter;
        if (importResourceResolver != null && (importerExporter = this.getCacheDataImporterExporter()) instanceof ResourceCapableCacheDataImporterExporter) {
            ((ResourceCapableCacheDataImporterExporter)importerExporter).setImportResourceResolver(importResourceResolver);
        }
    }

    public int getPhase() {
        return this.resolveImportPhase();
    }

    @NonNull
    Set<Region> getRegionsForImport() {
        return this.regionsForImport;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        CacheDataImporterExporter importerExporter;
        if (resourceLoader != null && (importerExporter = this.getCacheDataImporterExporter()) instanceof ResourceLoaderAware) {
            ((ResourceLoaderAware)importerExporter).setResourceLoader(resourceLoader);
        }
    }

    @Autowired(required=false)
    public void setResourceReader(@Nullable ResourceReader resourceReader) {
        CacheDataImporterExporter importerExporter;
        if (resourceReader != null && (importerExporter = this.getCacheDataImporterExporter()) instanceof ResourceCapableCacheDataImporterExporter) {
            ((ResourceCapableCacheDataImporterExporter)importerExporter).setResourceReader(resourceReader);
        }
    }

    @Autowired(required=false)
    public void setResourceWriter(@Nullable ResourceWriter resourceWriter) {
        CacheDataImporterExporter importerExporter;
        if (resourceWriter != null && (importerExporter = this.getCacheDataImporterExporter()) instanceof ResourceCapableCacheDataImporterExporter) {
            ((ResourceCapableCacheDataImporterExporter)importerExporter).setResourceWriter(resourceWriter);
        }
    }

    @Override
    @NonNull
    public Region exportFrom(@NonNull Region region) {
        return this.getCacheDataImporterExporter().exportFrom(region);
    }

    @Override
    @NonNull
    public Region importInto(@NonNull Region region) {
        if (this.resolveImportLifecycle().isEager()) {
            return this.getCacheDataImporterExporter().importInto(region);
        }
        this.getRegionsForImport().add(region);
        return region;
    }

    protected ImportLifecycle resolveImportLifecycle() {
        return this.resolvedImportLifecycle.updateAndGet(currentValue -> currentValue != null ? currentValue : this.getEnvironment().map(env -> (String)env.getProperty(CACHE_DATA_IMPORT_LIFECYCLE_PROPERTY_NAME, String.class, (Object)ImportLifecycle.getDefault().name())).map(ImportLifecycle::from).orElseGet(ImportLifecycle::getDefault));
    }

    protected int resolveImportPhase() {
        return this.resolvedImportPhase.updateAndGet(currentValue -> currentValue != null ? currentValue : this.getEnvironment().map(env -> (Integer)env.getProperty(CACHE_DATA_IMPORT_PHASE_PROPERTY_NAME, Integer.class, (Object)-2146483648)).orElse(-2146483648));
    }

    public void start() {
        if (this.resolveImportLifecycle().isLazy()) {
            this.getRegionsForImport().forEach(this.getCacheDataImporterExporter()::importInto);
        }
    }

    public static enum ImportLifecycle {
        EAGER("Imports cache data during Region bean post processing, after initialization"),
        LAZY("Imports cache data during the appropriate phase on Lifecycle start");

        private final String description;

        private ImportLifecycle(String description) {
            Assert.hasText((String)description, (String)"The enumerated value must have a description");
            this.description = description;
        }

        @NonNull
        public static ImportLifecycle getDefault() {
            return LAZY;
        }

        @Nullable
        public static ImportLifecycle from(String name) {
            for (ImportLifecycle importCycle : ImportLifecycle.values()) {
                if (!importCycle.name().equalsIgnoreCase(name)) continue;
                return importCycle;
            }
            return null;
        }

        public boolean isEager() {
            return EAGER.equals((Object)this);
        }

        public boolean isLazy() {
            return LAZY.equals((Object)this);
        }

        public String toString() {
            return this.description;
        }
    }
}

