/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.data.json.converter.support;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.POJONode;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.data.mapping.MappingException;
import org.springframework.geode.data.json.converter.JsonToObjectConverter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class JacksonJsonToObjectConverter
implements JsonToObjectConverter {
    protected static final String AT_TYPE_FIELD_NAME = "@type";
    private ObjectMapper objectMapper = this.newObjectMapper();

    @NonNull
    private ObjectMapper newObjectMapper() {
        return new ObjectMapper().configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS, true).findAndRegisterModules();
    }

    @NonNull
    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Nullable
    public Object convert(@Nullable String json) {
        if (StringUtils.hasText((String)json)) {
            String objectTypeName = null;
            try {
                ObjectMapper objectMapper = this.getObjectMapper();
                JsonNode jsonNode = objectMapper.readTree(json);
                if (this.isPojo(jsonNode)) {
                    return ((POJONode)jsonNode).getPojo();
                }
                Assert.state((boolean)jsonNode.isObject(), () -> String.format("The JSON [%s] must be an object", json));
                Assert.state((boolean)jsonNode.has(AT_TYPE_FIELD_NAME), () -> String.format("The JSON object [%1$s] must have an '%2$s' metadata field", json, AT_TYPE_FIELD_NAME));
                objectTypeName = jsonNode.get(AT_TYPE_FIELD_NAME).asText();
                Class objectType = ClassUtils.forName((String)objectTypeName, (ClassLoader)Thread.currentThread().getContextClassLoader());
                return objectMapper.readValue(json, objectType);
            }
            catch (ClassNotFoundException cause) {
                throw new MappingException(String.format("Failed to map JSON [%1$s] to an Object of type [%2$s]", json, objectTypeName), (Throwable)cause);
            }
            catch (JsonProcessingException cause) {
                throw new DataRetrievalFailureException(String.format("Failed to read JSON [%s]", json), (Throwable)cause);
            }
        }
        return null;
    }

    boolean isPojo(@Nullable JsonNode jsonNode) {
        return jsonNode != null && (jsonNode instanceof POJONode || jsonNode.isPojo() || JsonNodeType.POJO.equals((Object)jsonNode.getNodeType()));
    }
}

