/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.data.json;

import java.util.Arrays;
import java.util.Collection;
import org.apache.geode.cache.Region;
import org.apache.geode.pdx.PdxInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.geode.data.json.converter.AbstractObjectArrayToJsonConverter;
import org.springframework.geode.data.json.converter.JsonToPdxArrayConverter;
import org.springframework.geode.data.json.converter.support.JacksonJsonToPdxConverter;
import org.springframework.geode.data.support.ResourceCapableCacheDataImporterExporter;
import org.springframework.geode.pdx.ObjectPdxInstanceAdapter;
import org.springframework.geode.pdx.PdxInstanceWrapper;
import org.springframework.geode.util.CacheUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class JsonCacheDataImporterExporter
extends ResourceCapableCacheDataImporterExporter {
    protected static final PdxInstance[] EMPTY_PDX_INSTANCE_ARRAY = new PdxInstance[0];
    @Autowired(required=false)
    private JsonToPdxArrayConverter jsonToPdxArrayConverter;
    private final RegionValuesToJsonConverter regionValuesToJsonConverter = new RegionValuesToJsonConverter();

    private static <T> boolean isNotEmpty(T ... array) {
        return array != null && array.length > 0;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.jsonToPdxArrayConverter = this.jsonToPdxArrayConverter != null ? this.jsonToPdxArrayConverter : this.newJsonToPdxArrayConverter();
    }

    @NonNull
    private JsonToPdxArrayConverter newJsonToPdxArrayConverter() {
        return new JacksonJsonToPdxConverter();
    }

    @NonNull
    protected JsonToPdxArrayConverter getJsonToPdxArrayConverter() {
        return this.jsonToPdxArrayConverter;
    }

    @Override
    @NonNull
    public Region doExportFrom(@NonNull Region region) {
        Assert.notNull((Object)region, (String)"Region must not be null");
        this.getExportResourceResolver().resolve(region).ifPresent(resource -> {
            String json = this.toJson(region);
            this.getLogger().debug("Saving JSON [{}] from Region [{}]", (Object)json, (Object)region.getName());
            this.getResourceWriter().write((Resource)resource, json.getBytes());
        });
        return region;
    }

    @Override
    @NonNull
    public Region doImportInto(@NonNull Region region) {
        Assert.notNull((Object)region, (String)"Region must not be null");
        this.getImportResourceResolver().resolve(region).map(this.getResourceReader()::read).map(this::toPdx).ifPresent(pdxInstances -> this.regionPutPdx(region, (PdxInstance[])pdxInstances));
        return region;
    }

    void regionPutPdx(@NonNull Region region, @Nullable PdxInstance[] pdx) {
        Arrays.stream(ArrayUtils.nullSafeArray((Object[])pdx, PdxInstance.class)).forEach(pdxInstance -> region.put(this.resolveKey((PdxInstance)pdxInstance), this.resolveValue((PdxInstance)pdxInstance)));
    }

    protected PdxInstance postProcess(PdxInstance pdxInstance) {
        return pdxInstance;
    }

    @NonNull
    protected Object resolveKey(@NonNull PdxInstance pdxInstance) {
        return PdxInstanceWrapper.from((PdxInstance)pdxInstance).getIdentifier();
    }

    @Nullable
    protected Object resolveValue(@Nullable PdxInstance pdxInstance) {
        return ObjectPdxInstanceAdapter.unwrap(PdxInstanceWrapper.unwrap((PdxInstance)this.postProcess(pdxInstance)));
    }

    @NonNull
    protected String toJson(@NonNull Region region) {
        return this.regionValuesToJsonConverter.convert(region);
    }

    @NonNull
    protected PdxInstance[] toPdx(@NonNull byte[] json) {
        return JsonCacheDataImporterExporter.isNotEmpty(new byte[][]{json}) ? this.getJsonToPdxArrayConverter().convert(json) : EMPTY_PDX_INSTANCE_ARRAY;
    }

    static class RegionValuesToJsonConverter
    extends AbstractObjectArrayToJsonConverter {
        RegionValuesToJsonConverter() {
        }

        @NonNull
        <K, V> String convert(@NonNull Region<K, V> region) {
            Assert.notNull(region, (String)"Region must not be null");
            return super.convert(CollectionUtils.nullSafeCollection((Collection)CacheUtils.collectValues(region)));
        }
    }
}

