/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.core.env;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.geode.core.env.support.CloudCacheService;
import org.springframework.geode.core.env.support.Service;
import org.springframework.geode.core.env.support.User;
import org.springframework.geode.core.util.ObjectUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class VcapPropertySource
extends PropertySource<EnumerablePropertySource<?>>
implements Iterable<String> {
    private static final String CLOUD_CACHE_TAG_NAME = "cloudcache";
    private static final String GEMFIRE_TAG_NAME = "gemfire";
    private static final String THIS_PROPERTY_SOURCE_NAME = "boot.data.gemfire.vcap";
    private static final String VCAP_APPLICATION_PROPERTY = "vcap.application.";
    private static final String VCAP_APPLICATION_NAME_PROPERTY = "vcap.application.name";
    private static final String VCAP_APPLICATION_URIS_PROPERTY = "vcap.application.uris";
    private static final String VCAP_PROPERTY_SOURCE_NAME = "vcap";
    private static final String VCAP_SERVICES_PROPERTY = "vcap.services.";
    private static final String VCAP_SERVICES_SERVICE_NAME_LOCATORS_PROPERTY = "vcap.services.%s.credentials.locators";
    private static final String VCAP_SERVICES_SERVICE_NAME_NAME_PROPERTY = "vcap.services.%s.name";
    private static final String VCAP_SERVICES_SERVICE_NAME_TLS_ENABLED_PROPERTY = "vcap.services.%s.credentials.tls-enabled";
    private static final String VCAP_SERVICES_SERVICE_NAME_URL_GFSH_PROPERTY = "vcap.services.%s.credentials.urls.gfsh";
    private static final String VCAP_SERVICES_SERVICE_NAME_USERS_PROPERTY = "vcap.services.%s.credentials.users";
    private static final String VCAP_SERVICES_SERVICE_NAME_USERS_INDEX_PROPERTY = "vcap.services.%s.credentials.users[%d]";
    private static final Predicate<Object> CLOUD_CACHE_SERVICE_PREDICATE = propertyValue -> String.valueOf(propertyValue).toLowerCase().contains(CLOUD_CACHE_TAG_NAME);
    private static final Predicate<Object> GEMFIRE_SERVICE_PREDICATE = propertyValue -> String.valueOf(propertyValue).toLowerCase().contains(GEMFIRE_TAG_NAME);
    private static final Predicate<Object> CLOUD_CACHE_AND_GEMFIRE_SERVICE_PREDICATE = CLOUD_CACHE_SERVICE_PREDICATE.and(GEMFIRE_SERVICE_PREDICATE);
    private static final Predicate<String> VCAP_APPLICATION_PROPERTIES_PREDICATE = propertyName -> String.valueOf(propertyName).trim().toLowerCase().startsWith(VCAP_APPLICATION_PROPERTY);
    private static final Predicate<PropertySource<?>> VCAP_REQUIRED_PROPERTIES_PREDICATE = propertySource -> propertySource.containsProperty(VCAP_APPLICATION_NAME_PROPERTY) && propertySource.containsProperty(VCAP_APPLICATION_URIS_PROPERTY);
    private static final Predicate<String> VCAP_SERVICES_PROPERTIES_PREDICATE = propertyName -> String.valueOf(propertyName).trim().toLowerCase().startsWith(VCAP_SERVICES_PROPERTY);
    private Predicate<String> vcapServicePredicate;

    public static VcapPropertySource from(Environment environment) {
        return Optional.ofNullable(environment).filter(ConfigurableEnvironment.class::isInstance).map(ConfigurableEnvironment.class::cast).map(ConfigurableEnvironment::getPropertySources).map(propertySources -> propertySources.get(VCAP_PROPERTY_SOURCE_NAME)).map(VcapPropertySource::from).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException((String)"Environment was not configurable or does not contain an enumerable [%s] PropertySource", (Object[])new Object[]{VCAP_PROPERTY_SOURCE_NAME}));
    }

    public static VcapPropertySource from(Properties properties) {
        return Optional.ofNullable(properties).map(it -> new PropertiesPropertySource(THIS_PROPERTY_SOURCE_NAME, properties)).filter(VCAP_REQUIRED_PROPERTIES_PREDICATE).map(VcapPropertySource::new).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException((String)"Properties are required", (Object[])new Object[0]));
    }

    public static VcapPropertySource from(PropertySource<?> propertySource) {
        return Optional.ofNullable(propertySource).filter(it -> VCAP_PROPERTY_SOURCE_NAME.equals(it.getName())).filter(VCAP_REQUIRED_PROPERTIES_PREDICATE).filter(EnumerablePropertySource.class::isInstance).map(EnumerablePropertySource.class::cast).map(VcapPropertySource::new).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException((String)"An EnumerablePropertySource named [%s] containing VCAP properties is required", (Object[])new Object[]{VCAP_PROPERTY_SOURCE_NAME}));
    }

    private VcapPropertySource(EnumerablePropertySource<?> propertySource) {
        super(THIS_PROPERTY_SOURCE_NAME, propertySource);
    }

    protected Set<String> findAllPropertiesByNameMatching(Predicate<String> predicate) {
        return this.findAllPropertiesByNameMatching(this, predicate);
    }

    protected Set<String> findAllPropertiesByNameMatching(Iterable<String> properties, Predicate<String> predicate) {
        return StreamSupport.stream(CollectionUtils.nullSafeIterable(properties).spliterator(), false).filter(predicate).collect(Collectors.toSet());
    }

    protected Set<String> findAllPropertiesByValueMatching(Predicate<Object> predicate) {
        return this.findAllPropertiesByValueMatching(this, predicate);
    }

    protected Set<String> findAllPropertiesByValueMatching(Iterable<String> properties, Predicate<Object> predicate) {
        return StreamSupport.stream(CollectionUtils.nullSafeIterable(properties).spliterator(), false).filter(propertyName -> predicate.test(this.getProperty((String)propertyName))).collect(Collectors.toSet());
    }

    public Set<String> findAllVcapApplicationProperties() {
        return this.findAllPropertiesByNameMatching(VCAP_APPLICATION_PROPERTIES_PREDICATE);
    }

    public Set<String> findAllVcapServicesProperties() {
        return this.findTargetVcapServiceProperties(VCAP_SERVICES_PROPERTIES_PREDICATE);
    }

    public Set<String> findTargetVcapServiceProperties(Predicate<String> vcapServicePropertiesPredicate) {
        return this.findAllPropertiesByNameMatching(this.filterByVcapServicePropertiesPredicate(vcapServicePropertiesPredicate));
    }

    private Predicate<String> filterByVcapServicePropertiesPredicate(Predicate<String> vcapServicePropertiesPredicate) {
        return this.isValid(vcapServicePropertiesPredicate) ? VCAP_SERVICES_PROPERTIES_PREDICATE.and(vcapServicePropertiesPredicate) : VCAP_SERVICES_PROPERTIES_PREDICATE;
    }

    private boolean isValid(Predicate<String> vcapServicePropertiesPredicate) {
        return vcapServicePropertiesPredicate != null && vcapServicePropertiesPredicate != VCAP_SERVICES_PROPERTIES_PREDICATE;
    }

    public Optional<CloudCacheService> findFirstCloudCacheService() {
        return this.findFirstCloudCacheServiceName().map(serviceName -> {
            CloudCacheService service = CloudCacheService.with(serviceName);
            Object locators = this.getProperty(String.format(VCAP_SERVICES_SERVICE_NAME_LOCATORS_PROPERTY, service));
            Optional.ofNullable(locators).map(String::valueOf).filter(StringUtils::hasText).ifPresent(service::withLocators);
            Object tlsEnabled = this.getProperty(String.format(VCAP_SERVICES_SERVICE_NAME_TLS_ENABLED_PROPERTY, service));
            Optional.ofNullable(tlsEnabled).map(String::valueOf).map(Boolean::parseBoolean).ifPresent(service::withTls);
            Object gfshUrl = this.getProperty(String.format(VCAP_SERVICES_SERVICE_NAME_URL_GFSH_PROPERTY, service));
            Optional.ofNullable(gfshUrl).map(String::valueOf).filter(StringUtils::hasText).map(urlString -> ObjectUtils.doOperationSafely(() -> new URL((String)urlString))).ifPresent(service::withGfshUrl);
            return service;
        });
    }

    public CloudCacheService requireFirstCloudCacheService() {
        return this.findFirstCloudCacheService().orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException((String)"Unable to resolve a CloudCache Service Instance", (Object[])new Object[0]));
    }

    public Optional<String> findFirstCloudCacheServiceName() {
        Set<String> vcapServicesProperties = this.findTargetVcapServiceProperties(this.getVcapServicePredicate());
        return this.findAllPropertiesByValueMatching(vcapServicesProperties, CLOUD_CACHE_AND_GEMFIRE_SERVICE_PREDICATE).stream().filter(propertyName -> propertyName.endsWith(".tags")).map(propertyName -> propertyName.substring(VCAP_SERVICES_PROPERTY.length())).map(propertyName -> propertyName.substring(0, propertyName.indexOf("."))).filter(StringUtils::hasText).min(String.CASE_INSENSITIVE_ORDER);
    }

    public String requireFirstCloudCacheServiceName() {
        String tags = String.format("%1$s, %2$s", CLOUD_CACHE_TAG_NAME, GEMFIRE_TAG_NAME);
        return this.findFirstCloudCacheServiceName().orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException((String)"No service with tags [%s] was found", (Object[])new Object[]{tags}));
    }

    public Optional<User> findUserByName(Service service, String targetUsername) {
        String username;
        Assert.hasText((String)targetUsername, (String)String.format("Target username [%s] is required", targetUsername));
        Optional<User> optionalUser = Optional.empty();
        String serviceName = service.getName();
        String userPropertyName = String.format(VCAP_SERVICES_SERVICE_NAME_USERS_INDEX_PROPERTY, serviceName, 0);
        int index = 1;
        while (this.containsProperty(this.asUserUsernameProperty(userPropertyName)) && !(username = String.valueOf(this.getProperty(this.asUserUsernameProperty(userPropertyName)))).equals(targetUsername)) {
            userPropertyName = String.format(VCAP_SERVICES_SERVICE_NAME_USERS_INDEX_PROPERTY, serviceName, index);
            ++index;
        }
        if (this.containsProperty(this.asUserUsernameProperty(userPropertyName))) {
            String username2 = String.valueOf(this.getProperty(this.asUserUsernameProperty(userPropertyName)));
            String password = String.valueOf(this.getProperty(this.asUserPasswordProperty(userPropertyName)));
            User user = User.with(username2).withPassword(password);
            optionalUser = Optional.of(user);
        }
        return optionalUser;
    }

    public Optional<User> findFirstUserByRoleClusterOperator(Service service) {
        String roles;
        Optional<User> optionalUser = Optional.empty();
        String serviceName = service.getName();
        String userPropertyName = String.format(VCAP_SERVICES_SERVICE_NAME_USERS_INDEX_PROPERTY, serviceName, 0);
        int index = 1;
        while (this.containsProperty(this.asUserRolesProperty(userPropertyName)) && !(roles = String.valueOf(this.getProperty(this.asUserRolesProperty(userPropertyName)))).contains(User.Role.CLUSTER_OPERATOR.name().toLowerCase())) {
            userPropertyName = String.format(VCAP_SERVICES_SERVICE_NAME_USERS_INDEX_PROPERTY, serviceName, index);
            ++index;
        }
        if (this.containsProperty(this.asUserUsernameProperty(userPropertyName))) {
            String username = String.valueOf(this.getProperty(this.asUserUsernameProperty(userPropertyName)));
            String password = String.valueOf(this.getProperty(this.asUserPasswordProperty(userPropertyName)));
            User user = User.with(username).withPassword(password).withRole(User.Role.CLUSTER_OPERATOR);
            optionalUser = Optional.of(user);
        }
        return optionalUser;
    }

    private String asUserPasswordProperty(String userProperty) {
        return String.format("%s.password", userProperty);
    }

    private String asUserRolesProperty(String userProperty) {
        return String.format("%s.roles", userProperty);
    }

    private String asUserUsernameProperty(String userProperty) {
        return String.format("%s.username", userProperty);
    }

    @Nullable
    public Object getProperty(String name) {
        return ((EnumerablePropertySource)this.getSource()).getProperty(name);
    }

    @NonNull
    protected Predicate<String> getVcapServicePredicate() {
        return this.vcapServicePredicate != null ? this.vcapServicePredicate : propertyName -> true;
    }

    @Override
    public Iterator<String> iterator() {
        return Collections.unmodifiableList(Arrays.asList(((EnumerablePropertySource)this.getSource()).getPropertyNames())).iterator();
    }

    @NonNull
    public VcapPropertySource withVcapServiceName(@NonNull String serviceName) {
        Assert.hasText((String)serviceName, (String)"Service name is required");
        String resolvedServiceName = StringUtils.trimAllWhitespace((String)serviceName);
        Predicate<String> vcapServiceNamePredicate = propertyName -> propertyName.startsWith(String.format("%1$s%2$s.", VCAP_SERVICES_PROPERTY, resolvedServiceName));
        return this.withVcapServicePredicate(vcapServiceNamePredicate);
    }

    @NonNull
    public VcapPropertySource withVcapServicePredicate(@Nullable Predicate<String> vcapServicePredicate) {
        this.vcapServicePredicate = vcapServicePredicate;
        return this;
    }
}

