/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.core.env;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class EnvironmentMapAdapter
extends AbstractMap<String, String> {
    private final Environment environment;

    public static EnvironmentMapAdapter from(@NonNull Environment environment) {
        return new EnvironmentMapAdapter(environment);
    }

    public EnvironmentMapAdapter(@NonNull Environment environment) {
        Assert.notNull((Object)environment, (String)"Environment must not be null");
        this.environment = environment;
    }

    @NonNull
    protected Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return key != null && this.getEnvironment().containsProperty(String.valueOf(key));
    }

    @Override
    @Nullable
    public String get(@Nullable Object key) {
        return key != null ? this.getEnvironment().getProperty(String.valueOf(key)) : null;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        Environment environment = this.getEnvironment();
        if (environment instanceof ConfigurableEnvironment) {
            HashSet<EnvironmentEntry> entrySet = new HashSet<EnvironmentEntry>();
            for (PropertySource propertySource : ((ConfigurableEnvironment)environment).getPropertySources()) {
                if (!(propertySource instanceof EnumerablePropertySource)) continue;
                for (String propertyName : ((EnumerablePropertySource)propertySource).getPropertyNames()) {
                    entrySet.add(new EnvironmentEntry(environment, propertyName));
                }
            }
            return Collections.unmodifiableSet(entrySet);
        }
        throw RuntimeExceptionFactory.newUnsupportedOperationException((String)"Unable to determine the entrySet from the Environment [%s]", (Object[])new Object[]{this.getEnvironment().getClass().getName()});
    }

    protected static class EnvironmentEntry
    implements Map.Entry<String, String> {
        private final Environment environment;
        private final String key;

        public EnvironmentEntry(@NonNull Environment environment, @NonNull String key) {
            Assert.notNull((Object)environment, (String)"Environment must not be null");
            Assert.hasText((String)key, () -> String.format("Key [%s] must be specified", key));
            this.environment = environment;
            this.key = key;
        }

        @NonNull
        protected Environment getEnvironment() {
            return this.environment;
        }

        @Override
        @NonNull
        public String getKey() {
            return this.key;
        }

        @Override
        @Nullable
        public String getValue() {
            return this.getEnvironment().getProperty(this.getKey());
        }

        @Override
        public String setValue(String value) {
            throw RuntimeExceptionFactory.newUnsupportedOperationException((String)"Setting the value of Environment property [%s] is not supported", (Object[])new Object[]{this.getKey()});
        }
    }
}

