/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.FallbackExceptionTranslationStrategy;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.AbstractRedisConnection;
import org.springframework.data.redis.connection.FutureResult;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.RedisHyperLogLogCommands;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.connection.RedisScriptingCommands;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisSubscribedConnectionException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.convert.TransactionResultConverter;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.JedisGeoCommands;
import org.springframework.data.redis.connection.jedis.JedisHashCommands;
import org.springframework.data.redis.connection.jedis.JedisHyperLogLogCommands;
import org.springframework.data.redis.connection.jedis.JedisKeyCommands;
import org.springframework.data.redis.connection.jedis.JedisListCommands;
import org.springframework.data.redis.connection.jedis.JedisMessageListener;
import org.springframework.data.redis.connection.jedis.JedisScriptingCommands;
import org.springframework.data.redis.connection.jedis.JedisSentinelConnection;
import org.springframework.data.redis.connection.jedis.JedisServerCommands;
import org.springframework.data.redis.connection.jedis.JedisSetCommands;
import org.springframework.data.redis.connection.jedis.JedisStringCommands;
import org.springframework.data.redis.connection.jedis.JedisSubscription;
import org.springframework.data.redis.connection.jedis.JedisZSetCommands;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.Builder;
import redis.clients.jedis.Client;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.Queable;
import redis.clients.jedis.Response;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.util.Pool;

public class JedisConnection
extends AbstractRedisConnection {
    private static final Field CLIENT_FIELD;
    private static final Method SEND_COMMAND;
    private static final Method GET_RESPONSE;
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION;
    private final Jedis jedis;
    private final Client client;
    @Nullable
    private Transaction transaction;
    @Nullable
    private final Pool<Jedis> pool;
    private boolean broken = false;
    @Nullable
    private volatile JedisSubscription subscription;
    @Nullable
    private volatile Pipeline pipeline;
    private final int dbIndex;
    private final String clientName;
    private boolean convertPipelineAndTxResults = true;
    private List<FutureResult<Response<?>>> pipelinedResults = new ArrayList();
    private Queue<FutureResult<Response<?>>> txResults = new LinkedList();

    public JedisConnection(Jedis jedis) {
        this(jedis, null, 0);
    }

    public JedisConnection(Jedis jedis, Pool<Jedis> pool, int dbIndex) {
        this(jedis, pool, dbIndex, null);
    }

    protected JedisConnection(Jedis jedis, @Nullable Pool<Jedis> pool, int dbIndex, String clientName) {
        this.client = (Client)ReflectionUtils.getField((Field)CLIENT_FIELD, (Object)jedis);
        this.jedis = jedis;
        this.pool = pool;
        this.dbIndex = dbIndex;
        this.clientName = clientName;
        if (dbIndex > 0) {
            try {
                this.select(dbIndex);
            }
            catch (DataAccessException ex) {
                this.close();
                throw ex;
            }
        }
    }

    protected DataAccessException convertJedisAccessException(Exception ex) {
        DataAccessException exception;
        if (ex instanceof NullPointerException) {
            this.broken = true;
        }
        if ((exception = EXCEPTION_TRANSLATION.translate(ex)) instanceof RedisConnectionFailureException) {
            this.broken = true;
        }
        return exception != null ? exception : new RedisSystemException(ex.getMessage(), ex);
    }

    @Override
    public RedisKeyCommands keyCommands() {
        return new JedisKeyCommands(this);
    }

    @Override
    public RedisStringCommands stringCommands() {
        return new JedisStringCommands(this);
    }

    @Override
    public RedisListCommands listCommands() {
        return new JedisListCommands(this);
    }

    @Override
    public RedisSetCommands setCommands() {
        return new JedisSetCommands(this);
    }

    @Override
    public RedisZSetCommands zSetCommands() {
        return new JedisZSetCommands(this);
    }

    @Override
    public RedisHashCommands hashCommands() {
        return new JedisHashCommands(this);
    }

    @Override
    public RedisGeoCommands geoCommands() {
        return new JedisGeoCommands(this);
    }

    @Override
    public RedisScriptingCommands scriptingCommands() {
        return new JedisScriptingCommands(this);
    }

    @Override
    public RedisServerCommands serverCommands() {
        return new JedisServerCommands(this);
    }

    @Override
    public RedisHyperLogLogCommands hyperLogLogCommands() {
        return new JedisHyperLogLogCommands(this);
    }

    @Override
    public Object execute(String command, byte[] ... args) {
        Assert.hasText((String)command, (String)"a valid command needs to be specified");
        try {
            ArrayList mArgs = new ArrayList();
            if (!ObjectUtils.isEmpty((Object[])args)) {
                Collections.addAll(mArgs, args);
            }
            ReflectionUtils.invokeMethod((Method)SEND_COMMAND, (Object)this.client, (Object[])new Object[]{Protocol.Command.valueOf((String)command.trim().toUpperCase()), mArgs.toArray((T[])new byte[mArgs.size()][])});
            if (this.isQueueing() || this.isPipelined()) {
                Pipeline target = this.isPipelined() ? this.pipeline : this.transaction;
                Response result = (Response)ReflectionUtils.invokeMethod((Method)GET_RESPONSE, (Object)target, (Object[])new Object[]{new Builder<Object>(){

                    public Object build(Object data) {
                        return data;
                    }

                    public String toString() {
                        return "Object";
                    }
                }});
                if (this.isPipelined()) {
                    this.pipeline(new JedisResult(result));
                } else {
                    this.transaction(new JedisResult(result));
                }
                return null;
            }
            return this.client.getOne();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void close() throws DataAccessException {
        super.close();
        if (this.pool != null) {
            if (this.broken) {
                this.pool.returnBrokenResource((Object)this.jedis);
            } else {
                try {
                    if (this.dbIndex > 0) {
                        this.jedis.select(0);
                    }
                    return;
                }
                catch (Exception ex) {
                    throw this.convertJedisAccessException(ex);
                }
                finally {
                    this.jedis.close();
                }
            }
        }
        Exception exc = null;
        if (this.isQueueing()) {
            try {
                this.client.quit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.client.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        try {
            this.jedis.quit();
        }
        catch (Exception ex) {
            exc = ex;
        }
        try {
            this.jedis.disconnect();
        }
        catch (Exception ex) {
            exc = ex;
        }
        if (exc != null) {
            throw this.convertJedisAccessException(exc);
        }
    }

    public Jedis getNativeConnection() {
        return this.jedis;
    }

    @Override
    public boolean isClosed() {
        try {
            return !this.jedis.isConnected();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public boolean isQueueing() {
        return this.client.isInMulti();
    }

    @Override
    public boolean isPipelined() {
        return this.pipeline != null;
    }

    @Override
    public void openPipeline() {
        if (this.pipeline == null) {
            this.pipeline = this.jedis.pipelined();
        }
    }

    @Override
    public List<Object> closePipeline() {
        if (this.pipeline != null) {
            try {
                List<Object> list = this.convertPipelineResults();
                return list;
            }
            finally {
                this.pipeline = null;
                this.pipelinedResults.clear();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> convertPipelineResults() {
        ArrayList<Object> results = new ArrayList<Object>();
        this.getRequiredPipeline().sync();
        DataAccessException cause = null;
        for (FutureResult<Response<?>> result : this.pipelinedResults) {
            try {
                Object data = result.get();
                if (this.convertPipelineAndTxResults && result.isStatus()) continue;
                results.add(data);
            }
            catch (JedisDataException e) {
                DataAccessException dataAccessException = this.convertJedisAccessException((Exception)((Object)e));
                if (cause == null) {
                    cause = dataAccessException;
                }
                results.add((Object)dataAccessException);
            }
            catch (DataAccessException e) {
                if (cause == null) {
                    cause = e;
                }
                results.add((Object)e);
            }
        }
        if (cause != null) {
            throw new RedisPipelineException((Exception)((Object)cause), (List<Object>)results);
        }
        return results;
    }

    void pipeline(FutureResult<Response<?>> result) {
        if (this.isQueueing()) {
            this.transaction(result);
        } else {
            this.pipelinedResults.add(result);
        }
    }

    void transaction(FutureResult<Response<?>> result) {
        this.txResults.add(result);
    }

    @Override
    public byte[] echo(byte[] message) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.getRequiredPipeline().echo(message)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.getRequiredTransaction().echo(message)));
                return null;
            }
            return this.jedis.echo(message);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public String ping() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.getRequiredPipeline().ping()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.getRequiredTransaction().ping()));
                return null;
            }
            return this.jedis.ping();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void discard() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisStatusResult((Response<?>)this.getRequiredPipeline().discard()));
                return;
            }
            this.getRequiredTransaction().discard();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
        finally {
            this.txResults.clear();
            this.transaction = null;
        }
    }

    @Override
    public List<Object> exec() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.getRequiredPipeline().exec(), new TransactionResultConverter(new LinkedList(this.txResults), JedisConverters.exceptionConverter())));
                List<Object> list = null;
                return list;
            }
            if (this.transaction == null) {
                throw new InvalidDataAccessApiUsageException("No ongoing transaction. Did you forget to call multi?");
            }
            List<Object> results = this.transaction.exec();
            List<Object> list = this.convertPipelineAndTxResults && !CollectionUtils.isEmpty((Collection)results) ? new TransactionResultConverter(this.txResults, JedisConverters.exceptionConverter()).convert(results) : results;
            return list;
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
        finally {
            this.txResults.clear();
            this.transaction = null;
        }
    }

    @Nullable
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public Pipeline getRequiredPipeline() {
        Pipeline pipeline = this.getPipeline();
        if (pipeline == null) {
            throw new IllegalStateException("Connection has no active pipeline");
        }
        return pipeline;
    }

    @Nullable
    public Transaction getTransaction() {
        return this.transaction;
    }

    public Transaction getRequiredTransaction() {
        Transaction transaction = this.getTransaction();
        if (transaction == null) {
            throw new IllegalStateException("Connection has no active transaction");
        }
        return transaction;
    }

    public Jedis getJedis() {
        return this.jedis;
    }

    JedisResult newJedisResult(Response<?> response) {
        return new JedisResult(response);
    }

    <T> JedisResult newJedisResult(Response<T> response, Converter<T, ?> converter) {
        return new JedisResult(response, converter);
    }

    JedisStatusResult newStatusResult(Response<?> response) {
        return new JedisStatusResult(response);
    }

    <T> JedisStatusResult newStatusResult(Response<T> response, Converter<T, ?> converter) {
        return new JedisStatusResult(response, converter);
    }

    @Override
    public void multi() {
        if (this.isQueueing()) {
            return;
        }
        try {
            if (this.isPipelined()) {
                this.getRequiredPipeline().multi();
                return;
            }
            this.transaction = this.jedis.multi();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void select(int dbIndex) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisStatusResult((Response<?>)this.getRequiredPipeline().select(dbIndex)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisStatusResult((Response<?>)this.getRequiredTransaction().select(dbIndex)));
                return;
            }
            this.jedis.select(dbIndex);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void unwatch() {
        try {
            this.jedis.unwatch();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void watch(byte[] ... keys) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        try {
            for (byte[] key : keys) {
                if (this.isPipelined()) {
                    this.pipeline(new JedisStatusResult((Response<?>)this.getRequiredPipeline().watch((byte[][])new byte[][]{key})));
                    continue;
                }
                this.jedis.watch((byte[][])new byte[][]{key});
            }
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.getRequiredPipeline().publish(channel, message)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.getRequiredTransaction().publish(channel, message)));
                return null;
            }
            return this.jedis.publish(channel, message);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public boolean isSubscribed() {
        return this.subscription != null && this.subscription.isAlive();
    }

    @Override
    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            JedisMessageListener jedisPubSub = new JedisMessageListener(listener);
            this.subscription = new JedisSubscription(listener, jedisPubSub, null, patterns);
            this.jedis.psubscribe((BinaryJedisPubSub)jedisPubSub, patterns);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void subscribe(MessageListener listener, byte[] ... channels) {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            JedisMessageListener jedisPubSub = new JedisMessageListener(listener);
            this.subscription = new JedisSubscription(listener, jedisPubSub, channels, null);
            this.jedis.subscribe((BinaryJedisPubSub)jedisPubSub, channels);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    public void setConvertPipelineAndTxResults(boolean convertPipelineAndTxResults) {
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isActive(RedisNode node) {
        Jedis temp = null;
        try {
            temp = this.getJedis(node);
            temp.connect();
            boolean bl = temp.ping().equalsIgnoreCase("pong");
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (temp != null) {
                temp.disconnect();
                temp.close();
            }
        }
    }

    @Override
    protected JedisSentinelConnection getSentinelConnection(RedisNode sentinel) {
        return new JedisSentinelConnection(this.getJedis(sentinel));
    }

    protected Jedis getJedis(RedisNode node) {
        Jedis jedis = new Jedis(node.getHost(), node.getPort().intValue());
        if (StringUtils.hasText((String)this.clientName)) {
            jedis.clientSetname(this.clientName);
        }
        return jedis;
    }

    static {
        EXCEPTION_TRANSLATION = new FallbackExceptionTranslationStrategy(JedisConverters.exceptionConverter());
        CLIENT_FIELD = ReflectionUtils.findField(BinaryJedis.class, (String)"client", Client.class);
        ReflectionUtils.makeAccessible((Field)CLIENT_FIELD);
        try {
            Class commandType = ClassUtils.isPresent((String)"redis.clients.jedis.ProtocolCommand", null) ? ClassUtils.forName((String)"redis.clients.jedis.ProtocolCommand", null) : ClassUtils.forName((String)"redis.clients.jedis.Protocol$Command", null);
            SEND_COMMAND = ReflectionUtils.findMethod(Connection.class, (String)"sendCommand", (Class[])new Class[]{commandType, byte[][].class});
        }
        catch (Exception e) {
            throw new NoClassDefFoundError("Could not find required flavor of command required by 'redis.clients.jedis.Connection#sendCommand'.");
        }
        ReflectionUtils.makeAccessible((Method)SEND_COMMAND);
        GET_RESPONSE = ReflectionUtils.findMethod(Queable.class, (String)"getResponse", (Class[])new Class[]{Builder.class});
        ReflectionUtils.makeAccessible((Method)GET_RESPONSE);
    }

    private class JedisStatusResult
    extends JedisResult {
        public JedisStatusResult(Response<?> resultHolder) {
            super(resultHolder);
            this.setStatus(true);
        }

        public <T> JedisStatusResult(Response<T> resultHolder, Converter<T, ?> converter) {
            super(resultHolder, converter);
            this.setStatus(true);
        }
    }

    class JedisResult
    extends FutureResult<Response<?>> {
        public <T> JedisResult(Response<T> resultHolder, Converter<T, ?> converter) {
            super(resultHolder, converter);
        }

        public <T> JedisResult(Response<T> resultHolder) {
            super(resultHolder);
        }

        @Override
        public Object get() {
            Object raw = ((Response)this.resultHolder).get();
            if (!JedisConnection.this.convertPipelineAndTxResults || raw == null) {
                return raw;
            }
            return this.converter != null ? this.converter.convert(raw) : raw;
        }
    }
}

