/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexDefinition;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.index.GeoSpatialIndexed;
import org.springframework.data.mongodb.core.index.GeospatialIndex;
import org.springframework.data.mongodb.core.index.HashIndexed;
import org.springframework.data.mongodb.core.index.HashedIndex;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexDirection;
import org.springframework.data.mongodb.core.index.IndexResolver;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.index.PartialIndexFilter;
import org.springframework.data.mongodb.core.index.TextIndexDefinition;
import org.springframework.data.mongodb.core.index.TextIndexed;
import org.springframework.data.mongodb.core.index.WildcardIndex;
import org.springframework.data.mongodb.core.index.WildcardIndexed;
import org.springframework.data.mongodb.core.mapping.BasicMongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.data.mongodb.util.DotPath;
import org.springframework.data.mongodb.util.DurationUtil;
import org.springframework.data.mongodb.util.MongoClientVersion;
import org.springframework.data.mongodb.util.spel.ExpressionUtils;
import org.springframework.data.spel.EvaluationContextProvider;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MongoPersistentEntityIndexResolver
implements IndexResolver {
    private static final Log LOGGER = LogFactory.getLog(MongoPersistentEntityIndexResolver.class);
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private EvaluationContextProvider evaluationContextProvider = EvaluationContextProvider.DEFAULT;

    public MongoPersistentEntityIndexResolver(MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        Assert.notNull(mappingContext, (String)"Mapping context must not be null in order to resolve index definitions");
        this.mappingContext = mappingContext;
    }

    public Iterable<? extends IndexDefinitionHolder> resolveIndexFor(TypeInformation<?> typeInformation) {
        return this.resolveIndexForEntity((MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(typeInformation));
    }

    public List<IndexDefinitionHolder> resolveIndexForEntity(MongoPersistentEntity<?> root) {
        Assert.notNull(root, (String)"MongoPersistentEntity must not be null");
        Document document = (Document)root.findAnnotation(Document.class);
        Assert.notNull((Object)document, () -> String.format("Entity %s is not a collection root; Make sure to annotate it with @Document", root.getName()));
        this.verifyWildcardIndexedProjection(root);
        ArrayList<IndexDefinitionHolder> indexInformation = new ArrayList<IndexDefinitionHolder>();
        String collection = root.getCollection();
        indexInformation.addAll(this.potentiallyCreateCompoundIndexDefinitions("", collection, root));
        indexInformation.addAll(this.potentiallyCreateWildcardIndexDefinitions("", collection, root));
        indexInformation.addAll(this.potentiallyCreateTextIndexDefinition(root, collection));
        root.doWithProperties(property -> this.potentiallyAddIndexForProperty(root, (MongoPersistentProperty)property, (List<IndexDefinitionHolder>)indexInformation, new CycleGuard()));
        indexInformation.addAll(this.resolveIndexesForDbrefs("", collection, root));
        return indexInformation;
    }

    private void verifyWildcardIndexedProjection(MongoPersistentEntity<?> entity) {
        entity.doWithAll(it -> {
            WildcardIndexed indexed;
            if (it.isAnnotationPresent(WildcardIndexed.class) && !ObjectUtils.isEmpty((Object)(indexed = (WildcardIndexed)it.getRequiredAnnotation(WildcardIndexed.class)).wildcardProjection())) {
                throw new MappingException(String.format("WildcardIndexed.wildcardProjection cannot be used on nested paths; Offending property: %s.%s", entity.getName(), it.getName()));
            }
        });
    }

    private void potentiallyAddIndexForProperty(MongoPersistentEntity<?> root, MongoPersistentProperty persistentProperty, List<IndexDefinitionHolder> indexes, CycleGuard guard) {
        block5: {
            try {
                List<IndexDefinitionHolder> indexDefinitions;
                if (MongoPersistentEntityIndexResolver.isMapWithoutWildcardIndex(persistentProperty)) {
                    return;
                }
                if (persistentProperty.isEntity()) {
                    indexes.addAll(this.resolveIndexForEntity((MongoPersistentEntity)this.mappingContext.getPersistentEntity((PersistentProperty)persistentProperty), persistentProperty.isUnwrapped() ? "" : persistentProperty.getFieldName(), CycleGuard.Path.of(persistentProperty), root.getCollection(), guard));
                }
                if (!(indexDefinitions = this.createIndexDefinitionHolderForProperty(persistentProperty.getFieldName(), root.getCollection(), persistentProperty)).isEmpty()) {
                    indexes.addAll(indexDefinitions);
                }
            }
            catch (CyclicPropertyReferenceException e) {
                if (!LOGGER.isInfoEnabled()) break block5;
                LOGGER.info((Object)e.getMessage());
            }
        }
    }

    private List<IndexDefinitionHolder> resolveIndexForClass(TypeInformation<?> type, String dotPath, CycleGuard.Path path, String collection, CycleGuard guard) {
        return this.resolveIndexForEntity((MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(type), dotPath, path, collection, guard);
    }

    private List<IndexDefinitionHolder> resolveIndexForEntity(MongoPersistentEntity<?> entity, String dotPath, CycleGuard.Path path, String collection, CycleGuard guard) {
        ArrayList<IndexDefinitionHolder> indexInformation = new ArrayList<IndexDefinitionHolder>();
        indexInformation.addAll(this.potentiallyCreateCompoundIndexDefinitions(dotPath, collection, entity));
        indexInformation.addAll(this.potentiallyCreateWildcardIndexDefinitions(dotPath, collection, entity));
        entity.doWithProperties(property -> this.guardAndPotentiallyAddIndexForProperty((MongoPersistentProperty)property, dotPath, path, collection, (List<IndexDefinitionHolder>)indexInformation, guard));
        indexInformation.addAll(this.resolveIndexesForDbrefs(dotPath, collection, entity));
        return indexInformation;
    }

    private void guardAndPotentiallyAddIndexForProperty(MongoPersistentProperty persistentProperty, String dotPath, CycleGuard.Path path, String collection, List<IndexDefinitionHolder> indexes, CycleGuard guard) {
        List<IndexDefinitionHolder> indexDefinitions;
        DotPath propertyDotPath = DotPath.from(dotPath);
        if (!persistentProperty.isUnwrapped()) {
            propertyDotPath = propertyDotPath.append(persistentProperty.getFieldName());
        }
        CycleGuard.Path propertyPath = path.append(persistentProperty);
        guard.protect(persistentProperty, propertyPath);
        if (MongoPersistentEntityIndexResolver.isMapWithoutWildcardIndex(persistentProperty)) {
            return;
        }
        if (persistentProperty.isEntity()) {
            try {
                indexes.addAll(this.resolveIndexForEntity((MongoPersistentEntity)this.mappingContext.getPersistentEntity((PersistentProperty)persistentProperty), propertyDotPath.toString(), propertyPath, collection, guard));
            }
            catch (CyclicPropertyReferenceException e) {
                LOGGER.info((Object)e.getMessage());
            }
        }
        if (!(indexDefinitions = this.createIndexDefinitionHolderForProperty(propertyDotPath.toString(), collection, persistentProperty)).isEmpty()) {
            indexes.addAll(indexDefinitions);
        }
    }

    private List<IndexDefinitionHolder> createIndexDefinitionHolderForProperty(String dotPath, String collection, MongoPersistentProperty persistentProperty) {
        ArrayList<IndexDefinitionHolder> indices = new ArrayList<IndexDefinitionHolder>(2);
        if (persistentProperty.isUnwrapped() && (persistentProperty.isAnnotationPresent(Indexed.class) || persistentProperty.isAnnotationPresent(HashIndexed.class) || persistentProperty.isAnnotationPresent(GeoSpatialIndexed.class))) {
            throw new InvalidDataAccessApiUsageException(String.format("Index annotation not allowed on unwrapped object for path '%s'", dotPath));
        }
        if (persistentProperty.isAnnotationPresent(Indexed.class)) {
            indices.add(this.createIndexDefinition(dotPath, collection, persistentProperty));
        } else if (persistentProperty.isAnnotationPresent(GeoSpatialIndexed.class)) {
            indices.add(this.createGeoSpatialIndexDefinition(dotPath, collection, persistentProperty));
        }
        if (persistentProperty.isAnnotationPresent(HashIndexed.class)) {
            indices.add(this.createHashedIndexDefinition(dotPath, collection, persistentProperty));
        }
        if (persistentProperty.isAnnotationPresent(WildcardIndexed.class)) {
            indices.add(this.createWildcardIndexDefinition(dotPath, collection, (WildcardIndexed)persistentProperty.getRequiredAnnotation(WildcardIndexed.class), (MongoPersistentEntity)this.mappingContext.getPersistentEntity((PersistentProperty)persistentProperty)));
        }
        return indices;
    }

    private List<IndexDefinitionHolder> potentiallyCreateCompoundIndexDefinitions(String dotPath, String collection, MongoPersistentEntity<?> entity) {
        if (entity.findAnnotation(CompoundIndexes.class) == null && entity.findAnnotation(CompoundIndex.class) == null) {
            return Collections.emptyList();
        }
        return this.createCompoundIndexDefinitions(dotPath, collection, entity);
    }

    private List<IndexDefinitionHolder> potentiallyCreateWildcardIndexDefinitions(String dotPath, String collection, MongoPersistentEntity<?> entity) {
        if (!entity.isAnnotationPresent(WildcardIndexed.class)) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new IndexDefinitionHolder(dotPath, this.createWildcardIndexDefinition(dotPath, collection, (WildcardIndexed)entity.getRequiredAnnotation(WildcardIndexed.class), entity), collection));
    }

    private Collection<? extends IndexDefinitionHolder> potentiallyCreateTextIndexDefinition(MongoPersistentEntity<?> root, String collection) {
        TextIndexDefinition indexDefinition;
        Object name = root.getType().getSimpleName() + "_TextIndex";
        if (((String)name).getBytes().length > 127) {
            String[] args = ClassUtils.getShortNameAsProperty((Class)root.getType()).split("\\.");
            name = "";
            Iterator<String> it = Arrays.asList(args).iterator();
            while (it.hasNext()) {
                if (!it.hasNext()) {
                    name = (String)name + it.next() + "_TextIndex";
                    continue;
                }
                name = (String)name + it.next().charAt(0) + ".";
            }
        }
        TextIndexDefinition.TextIndexDefinitionBuilder indexDefinitionBuilder = new TextIndexDefinition.TextIndexDefinitionBuilder().named((String)name);
        if (StringUtils.hasText((String)root.getLanguage())) {
            indexDefinitionBuilder.withDefaultLanguage(root.getLanguage());
        }
        try {
            this.appendTextIndexInformation(DotPath.empty(), CycleGuard.Path.empty(), indexDefinitionBuilder, root, new TextIndexIncludeOptions(TextIndexIncludeOptions.IncludeStrategy.DEFAULT), new CycleGuard());
        }
        catch (CyclicPropertyReferenceException e) {
            LOGGER.info((Object)e.getMessage());
        }
        if (root.hasCollation()) {
            indexDefinitionBuilder.withSimpleCollation();
        }
        if (!(indexDefinition = indexDefinitionBuilder.build()).hasFieldSpec()) {
            return Collections.emptyList();
        }
        IndexDefinitionHolder holder = new IndexDefinitionHolder("", indexDefinition, collection);
        return Collections.singletonList(holder);
    }

    private void appendTextIndexInformation(final DotPath dotPath, final CycleGuard.Path path, final TextIndexDefinition.TextIndexDefinitionBuilder indexDefinitionBuilder, final MongoPersistentEntity<?> entity, final TextIndexIncludeOptions includeOptions, final CycleGuard guard) {
        entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

            public void doWithPersistentProperty(MongoPersistentProperty persistentProperty) {
                guard.protect(persistentProperty, path);
                if (persistentProperty.isExplicitLanguageProperty() && dotPath.isEmpty()) {
                    indexDefinitionBuilder.withLanguageOverride(persistentProperty.getFieldName());
                }
                if (persistentProperty.isMap()) {
                    return;
                }
                TextIndexed indexed = (TextIndexed)persistentProperty.findAnnotation(TextIndexed.class);
                if (includeOptions.isForce() || indexed != null || persistentProperty.isEntity()) {
                    DotPath propertyDotPath = dotPath.append(persistentProperty.getFieldName());
                    CycleGuard.Path propertyPath = path.append(persistentProperty);
                    TextIndexDefinition.TextIndexedFieldSpec parentFieldSpec = includeOptions.getParentFieldSpec();
                    Float weight = Float.valueOf(indexed != null ? indexed.weight() : (parentFieldSpec != null ? parentFieldSpec.getWeight().floatValue() : 1.0f));
                    if (persistentProperty.isEntity()) {
                        TextIndexIncludeOptions optionsForNestedType = includeOptions;
                        if (!TextIndexIncludeOptions.IncludeStrategy.FORCE.equals((Object)includeOptions.getStrategy()) && indexed != null) {
                            optionsForNestedType = new TextIndexIncludeOptions(TextIndexIncludeOptions.IncludeStrategy.FORCE, new TextIndexDefinition.TextIndexedFieldSpec(propertyDotPath.toString(), weight));
                        }
                        try {
                            MongoPersistentEntityIndexResolver.this.appendTextIndexInformation(propertyDotPath, propertyPath, indexDefinitionBuilder, (MongoPersistentEntity)MongoPersistentEntityIndexResolver.this.mappingContext.getPersistentEntity(persistentProperty.getActualType()), optionsForNestedType, guard);
                        }
                        catch (CyclicPropertyReferenceException e) {
                            LOGGER.info((Object)e.getMessage());
                        }
                        catch (InvalidDataAccessApiUsageException e) {
                            LOGGER.info((Object)String.format("Potentially invalid index structure discovered; Breaking operation for %s", entity.getName()), (Throwable)e);
                        }
                    } else if (includeOptions.isForce() || indexed != null) {
                        indexDefinitionBuilder.onField(propertyDotPath.toString(), weight);
                    }
                }
            }
        });
    }

    protected List<IndexDefinitionHolder> createCompoundIndexDefinitions(String dotPath, String fallbackCollection, MongoPersistentEntity<?> entity) {
        CompoundIndex index2;
        List<IndexDefinitionHolder> indexDefinitions = new ArrayList<IndexDefinitionHolder>();
        CompoundIndexes indexes = (CompoundIndexes)entity.findAnnotation(CompoundIndexes.class);
        if (indexes != null) {
            indexDefinitions = Arrays.stream(indexes.value()).map(index -> this.createCompoundIndexDefinition(dotPath, fallbackCollection, (CompoundIndex)index, entity)).collect(Collectors.toList());
        }
        if ((index2 = (CompoundIndex)entity.findAnnotation(CompoundIndex.class)) != null) {
            indexDefinitions.add(this.createCompoundIndexDefinition(dotPath, fallbackCollection, index2, entity));
        }
        return indexDefinitions;
    }

    protected IndexDefinitionHolder createCompoundIndexDefinition(String dotPath, String collection, CompoundIndex index, MongoPersistentEntity<?> entity) {
        CompoundIndexDefinition indexDefinition = new CompoundIndexDefinition(this.resolveCompoundIndexKeyFromStringDefinition(dotPath, index.def(), (PersistentEntity<?, ?>)entity));
        if (!index.useGeneratedName()) {
            indexDefinition.named(this.pathAwareIndexName(index.name(), dotPath, (PersistentEntity<?, ?>)entity, null));
        }
        if (index.unique()) {
            indexDefinition.unique();
        }
        if (index.sparse()) {
            indexDefinition.sparse();
        }
        if (index.background()) {
            indexDefinition.background();
        }
        if (StringUtils.hasText((String)index.partialFilter())) {
            indexDefinition.partial(this.evaluatePartialFilter(index.partialFilter(), (PersistentEntity<?, ?>)entity));
        }
        indexDefinition.collation(this.resolveCollation(index, (PersistentEntity<?, ?>)entity));
        return new IndexDefinitionHolder(dotPath, indexDefinition, collection);
    }

    protected IndexDefinitionHolder createWildcardIndexDefinition(String dotPath, String collection, WildcardIndexed index, @Nullable MongoPersistentEntity<?> entity) {
        WildcardIndex indexDefinition = new WildcardIndex(dotPath);
        if (StringUtils.hasText((String)index.wildcardProjection()) && ObjectUtils.isEmpty((Object)dotPath)) {
            indexDefinition.wildcardProjection((Map<String, Object>)this.evaluateWildcardProjection(index.wildcardProjection(), (PersistentEntity<?, ?>)entity));
        }
        if (!index.useGeneratedName()) {
            indexDefinition.named(this.pathAwareIndexName(index.name(), dotPath, (PersistentEntity<?, ?>)entity, null));
        }
        if (StringUtils.hasText((String)index.partialFilter())) {
            indexDefinition.partial(this.evaluatePartialFilter(index.partialFilter(), (PersistentEntity<?, ?>)entity));
        }
        indexDefinition.collation(this.resolveCollation(index, (PersistentEntity<?, ?>)entity));
        return new IndexDefinitionHolder(dotPath, indexDefinition, collection);
    }

    private org.bson.Document resolveCompoundIndexKeyFromStringDefinition(String dotPath, String keyDefinitionString, PersistentEntity<?, ?> entity) {
        org.bson.Document document;
        org.bson.Document dbo;
        if (!StringUtils.hasText((String)dotPath) && !StringUtils.hasText((String)keyDefinitionString)) {
            throw new InvalidDataAccessApiUsageException("Cannot create index on root level for empty keys");
        }
        if (!StringUtils.hasText((String)keyDefinitionString)) {
            return new org.bson.Document(dotPath, (Object)1);
        }
        Object keyDefToUse = ExpressionUtils.evaluate(keyDefinitionString, () -> this.getEvaluationContextForProperty(entity));
        org.bson.Document document2 = dbo = keyDefToUse instanceof org.bson.Document ? (document = (org.bson.Document)keyDefToUse) : org.bson.Document.parse((String)ObjectUtils.nullSafeToString((Object)keyDefToUse));
        if (!StringUtils.hasText((String)dotPath)) {
            return dbo;
        }
        document = new org.bson.Document();
        for (String key : dbo.keySet()) {
            document.put(dotPath + "." + key, dbo.get((Object)key));
        }
        return document;
    }

    @Nullable
    protected IndexDefinitionHolder createIndexDefinition(String dotPath, String collection, MongoPersistentProperty persistentProperty) {
        Indexed index = (Indexed)persistentProperty.findAnnotation(Indexed.class);
        if (index == null) {
            return null;
        }
        Index indexDefinition = new Index().on(dotPath, IndexDirection.ASCENDING.equals((Object)index.direction()) ? Sort.Direction.ASC : Sort.Direction.DESC);
        if (!index.useGeneratedName()) {
            indexDefinition.named(this.pathAwareIndexName(index.name(), dotPath, persistentProperty.getOwner(), persistentProperty));
        }
        if (index.unique()) {
            indexDefinition.unique();
        }
        if (index.sparse()) {
            indexDefinition.sparse();
        }
        if (index.background()) {
            indexDefinition.background();
        }
        if (index.expireAfterSeconds() >= 0) {
            indexDefinition.expire(index.expireAfterSeconds(), TimeUnit.SECONDS);
        }
        if (StringUtils.hasText((String)index.expireAfter())) {
            if (index.expireAfterSeconds() >= 0) {
                throw new IllegalStateException(String.format("@Indexed already defines an expiration timeout of %s seconds via Indexed#expireAfterSeconds; Please make to use either expireAfterSeconds or expireAfter", index.expireAfterSeconds()));
            }
            Duration timeout = MongoPersistentEntityIndexResolver.computeIndexTimeout(index.expireAfter(), () -> this.getEvaluationContextForProperty(persistentProperty.getOwner()));
            if (!timeout.isNegative()) {
                indexDefinition.expire(timeout);
            }
        }
        if (StringUtils.hasText((String)index.partialFilter())) {
            indexDefinition.partial(this.evaluatePartialFilter(index.partialFilter(), persistentProperty.getOwner()));
        }
        indexDefinition.collation(this.resolveCollation(index, persistentProperty.getOwner()));
        return new IndexDefinitionHolder(dotPath, indexDefinition, collection);
    }

    private PartialIndexFilter evaluatePartialFilter(String filterExpression, PersistentEntity<?, ?> entity) {
        Object result = ExpressionUtils.evaluate(filterExpression, () -> this.getEvaluationContextForProperty(entity));
        if (result instanceof org.bson.Document) {
            org.bson.Document document = (org.bson.Document)result;
            return PartialIndexFilter.of(document);
        }
        return PartialIndexFilter.of(BsonUtils.parse(filterExpression, null));
    }

    private org.bson.Document evaluateWildcardProjection(String projectionExpression, PersistentEntity<?, ?> entity) {
        Object result = ExpressionUtils.evaluate(projectionExpression, () -> this.getEvaluationContextForProperty(entity));
        if (result instanceof org.bson.Document) {
            org.bson.Document document = (org.bson.Document)result;
            return document;
        }
        return BsonUtils.parse(projectionExpression, null);
    }

    private Collation evaluateCollation(String collationExpression, PersistentEntity<?, ?> entity) {
        Object result = ExpressionUtils.evaluate(collationExpression, () -> this.getEvaluationContextForProperty(entity));
        if (result instanceof org.bson.Document) {
            org.bson.Document document = (org.bson.Document)result;
            return Collation.from(document);
        }
        if (result instanceof Collation) {
            Collation collation = (Collation)result;
            return collation;
        }
        if (result instanceof String) {
            String stringValue = (String)result;
            return Collation.parse(stringValue);
        }
        if (result instanceof Map) {
            return Collation.from(new org.bson.Document((Map)result));
        }
        throw new IllegalStateException("Cannot parse collation " + String.valueOf(result));
    }

    @Nullable
    protected IndexDefinitionHolder createHashedIndexDefinition(String dotPath, String collection, MongoPersistentProperty persistentProperty) {
        HashIndexed index = (HashIndexed)persistentProperty.findAnnotation(HashIndexed.class);
        if (index == null) {
            return null;
        }
        return new IndexDefinitionHolder(dotPath, HashedIndex.hashed(dotPath), collection);
    }

    protected EvaluationContext getEvaluationContext() {
        return this.evaluationContextProvider.getEvaluationContext(null);
    }

    private EvaluationContext getEvaluationContextForProperty(@Nullable PersistentEntity<?, ?> persistentEntity) {
        if (persistentEntity == null || !(persistentEntity instanceof BasicMongoPersistentEntity)) {
            return this.getEvaluationContext();
        }
        EvaluationContext contextFromEntity = ((BasicMongoPersistentEntity)persistentEntity).getEvaluationContext(null);
        if (contextFromEntity != null && !EvaluationContextProvider.DEFAULT.equals(contextFromEntity)) {
            return contextFromEntity;
        }
        return this.getEvaluationContext();
    }

    public void setEvaluationContextProvider(EvaluationContextProvider evaluationContextProvider) {
        this.evaluationContextProvider = evaluationContextProvider;
    }

    @Nullable
    protected IndexDefinitionHolder createGeoSpatialIndexDefinition(String dotPath, String collection, MongoPersistentProperty persistentProperty) {
        GeoSpatialIndexed index = (GeoSpatialIndexed)persistentProperty.findAnnotation(GeoSpatialIndexed.class);
        if (index == null) {
            return null;
        }
        GeospatialIndex indexDefinition = new GeospatialIndex(dotPath);
        indexDefinition.withBits(index.bits());
        indexDefinition.withMin(index.min()).withMax(index.max());
        if (!index.useGeneratedName()) {
            indexDefinition.named(this.pathAwareIndexName(index.name(), dotPath, persistentProperty.getOwner(), persistentProperty));
        }
        if (MongoClientVersion.isVersion5orNewer()) {
            Optional defaultBucketSize = MergedAnnotation.of(GeoSpatialIndexed.class).getDefaultValue("bucketSize", Double.class);
            if (!defaultBucketSize.isPresent() || index.bucketSize() != ((Double)defaultBucketSize.get()).doubleValue()) {
                indexDefinition.withBucketSize(index.bucketSize());
            } else if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"GeoSpatialIndexed.bucketSize no longer supported by Mongo Client 5 or newer. Ignoring bucketSize for path %s.".formatted(dotPath));
            }
        } else {
            indexDefinition.withBucketSize(index.bucketSize());
        }
        indexDefinition.typed(index.type()).withAdditionalField(index.additionalField());
        return new IndexDefinitionHolder(dotPath, indexDefinition, collection);
    }

    private String pathAwareIndexName(String indexName, String dotPath, @Nullable PersistentEntity<?, ?> entity, @Nullable MongoPersistentProperty property) {
        Object result;
        String nameToUse = "";
        if (StringUtils.hasText((String)indexName) && (result = ExpressionUtils.evaluate(indexName, () -> this.getEvaluationContextForProperty(entity))) != null) {
            nameToUse = ObjectUtils.nullSafeToString((Object)result);
        }
        if (!StringUtils.hasText((String)dotPath) || property != null && dotPath.equals(property.getFieldName())) {
            return StringUtils.hasText((String)nameToUse) ? nameToUse : dotPath;
        }
        if (StringUtils.hasText((String)dotPath)) {
            nameToUse = StringUtils.hasText((String)nameToUse) ? (property != null ? dotPath.replace("." + property.getFieldName(), "") : dotPath) + "." + nameToUse : dotPath;
        }
        return nameToUse;
    }

    private List<IndexDefinitionHolder> resolveIndexesForDbrefs(String path, String collection, MongoPersistentEntity<?> entity) {
        ArrayList<IndexDefinitionHolder> indexes = new ArrayList<IndexDefinitionHolder>(0);
        entity.doWithAssociations(association -> this.resolveAndAddIndexesForAssociation((Association<MongoPersistentProperty>)association, indexes, path, collection));
        return indexes;
    }

    private void resolveAndAddIndexesForAssociation(Association<MongoPersistentProperty> association, List<IndexDefinitionHolder> indexes, String path, String collection) {
        MongoPersistentProperty property = (MongoPersistentProperty)association.getInverse();
        DotPath propertyDotPath = DotPath.from(path).append(property.getFieldName());
        if (property.isAnnotationPresent(GeoSpatialIndexed.class) || property.isAnnotationPresent(TextIndexed.class)) {
            throw new MappingException(String.format("Cannot create geospatial-/text- index on DBRef in collection '%s' for path '%s'", collection, propertyDotPath));
        }
        List<IndexDefinitionHolder> indexDefinitions = this.createIndexDefinitionHolderForProperty(propertyDotPath.toString(), collection, property);
        if (!indexDefinitions.isEmpty()) {
            indexes.addAll(indexDefinitions);
        }
    }

    private static Duration computeIndexTimeout(String timeoutValue, Supplier<EvaluationContext> evaluationContext) {
        return DurationUtil.evaluate(timeoutValue, evaluationContext);
    }

    @Nullable
    private Collation resolveCollation(Annotation annotation, @Nullable PersistentEntity<?, ?> entity) {
        return MergedAnnotation.from((Annotation)annotation).getValue("collation", String.class).filter(StringUtils::hasText).map(it -> this.evaluateCollation((String)it, entity)).orElseGet(() -> {
            MongoPersistentEntity mongoPersistentEntity;
            if (entity instanceof MongoPersistentEntity && (mongoPersistentEntity = (MongoPersistentEntity)entity).hasCollation()) {
                return mongoPersistentEntity.getCollation();
            }
            return null;
        });
    }

    private static boolean isMapWithoutWildcardIndex(MongoPersistentProperty property) {
        return property.isMap() && !property.isAnnotationPresent(WildcardIndexed.class);
    }

    static class CycleGuard {
        private final Set<String> seenProperties = new HashSet<String>();

        CycleGuard() {
        }

        void protect(MongoPersistentProperty property, Path path) throws CyclicPropertyReferenceException {
            String propertyTypeKey = this.createMapKey(property);
            if (!this.seenProperties.add(propertyTypeKey) && path.isCycle()) {
                throw new CyclicPropertyReferenceException(property.getFieldName(), property.getOwner().getType(), path.toCyclePath());
            }
        }

        private String createMapKey(MongoPersistentProperty property) {
            return ClassUtils.getShortName((Class)property.getOwner().getType()) + ":" + property.getFieldName();
        }

        static class Path {
            private static final Path EMPTY = new Path(Collections.emptyList(), false);
            private final List<PersistentProperty<?>> elements;
            private final boolean cycle;

            private Path(List<PersistentProperty<?>> elements, boolean cycle) {
                this.elements = elements;
                this.cycle = cycle;
            }

            static Path empty() {
                return EMPTY;
            }

            static Path of(PersistentProperty<?> initial) {
                return new Path(Collections.singletonList(initial), false);
            }

            Path append(PersistentProperty<?> breadcrumb) {
                ArrayList elements = new ArrayList(this.elements.size() + 1);
                elements.addAll(this.elements);
                elements.add(breadcrumb);
                return new Path(elements, this.elements.contains(breadcrumb));
            }

            public boolean isCycle() {
                return this.cycle;
            }

            public String toString() {
                return this.elements.isEmpty() ? "(empty)" : Path.toPath(this.elements.iterator());
            }

            String toCyclePath() {
                if (!this.cycle) {
                    return "";
                }
                for (int i = 0; i < this.elements.size(); ++i) {
                    int index = Path.indexOf(this.elements, this.elements.get(i), i + 1);
                    if (index == -1) continue;
                    return Path.toPath(this.elements.subList(i, index + 1).iterator());
                }
                return this.toString();
            }

            private static <T> int indexOf(List<T> haystack, T needle, int offset) {
                for (int i = offset; i < haystack.size(); ++i) {
                    if (!haystack.get(i).equals(needle)) continue;
                    return i;
                }
                return -1;
            }

            private static String toPath(Iterator<PersistentProperty<?>> iterator) {
                StringBuilder builder = new StringBuilder();
                while (iterator.hasNext()) {
                    builder.append(iterator.next().getName());
                    if (!iterator.hasNext()) continue;
                    builder.append(" -> ");
                }
                return builder.toString();
            }

            public boolean equals(@Nullable Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Path that = (Path)o;
                if (this.cycle != that.cycle) {
                    return false;
                }
                return ObjectUtils.nullSafeEquals(this.elements, that.elements);
            }

            public int hashCode() {
                int result = ObjectUtils.nullSafeHashCode(this.elements);
                result = 31 * result + (this.cycle ? 1 : 0);
                return result;
            }
        }
    }

    public static class CyclicPropertyReferenceException
    extends RuntimeException {
        private static final long serialVersionUID = -3762979307658772277L;
        private final String propertyName;
        @Nullable
        private final Class<?> type;
        private final String dotPath;

        public CyclicPropertyReferenceException(String propertyName, @Nullable Class<?> type, String dotPath) {
            this.propertyName = propertyName;
            this.type = type;
            this.dotPath = dotPath;
        }

        @Override
        public String getMessage() {
            return String.format("Found cycle for field '%s' in type '%s' for path '%s'", this.propertyName, this.type != null ? this.type.getSimpleName() : "unknown", this.dotPath);
        }
    }

    public static class IndexDefinitionHolder
    implements IndexDefinition {
        private final String path;
        private final IndexDefinition indexDefinition;
        private final String collection;

        public IndexDefinitionHolder(String path, IndexDefinition definition, String collection) {
            this.path = path;
            this.indexDefinition = definition;
            this.collection = collection;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getPath() {
            return this.path;
        }

        public IndexDefinition getIndexDefinition() {
            return this.indexDefinition;
        }

        @Override
        public org.bson.Document getIndexKeys() {
            return this.indexDefinition.getIndexKeys();
        }

        @Override
        public org.bson.Document getIndexOptions() {
            return this.indexDefinition.getIndexOptions();
        }

        public String toString() {
            return "IndexDefinitionHolder{indexKeys=" + String.valueOf(this.getIndexKeys()) + "}";
        }
    }

    static class TextIndexIncludeOptions {
        private final IncludeStrategy strategy;
        @Nullable
        private final TextIndexDefinition.TextIndexedFieldSpec parentFieldSpec;

        public TextIndexIncludeOptions(IncludeStrategy strategy, @Nullable TextIndexDefinition.TextIndexedFieldSpec parentFieldSpec) {
            this.strategy = strategy;
            this.parentFieldSpec = parentFieldSpec;
        }

        public TextIndexIncludeOptions(IncludeStrategy strategy) {
            this(strategy, null);
        }

        public IncludeStrategy getStrategy() {
            return this.strategy;
        }

        @Nullable
        public TextIndexDefinition.TextIndexedFieldSpec getParentFieldSpec() {
            return this.parentFieldSpec;
        }

        public boolean isForce() {
            return IncludeStrategy.FORCE.equals((Object)this.strategy);
        }

        static enum IncludeStrategy {
            FORCE,
            DEFAULT;

        }
    }
}

