/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Score;
import org.springframework.data.domain.ScoringFunction;
import org.springframework.data.domain.Similarity;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;

public class JpaParametersParameterAccessor
extends ParametersParameterAccessor {
    private final JpaParameters parameters;

    public JpaParametersParameterAccessor(JpaParameters parameters, Object[] values) {
        super((Parameters)parameters, values);
        this.parameters = parameters;
    }

    public JpaParameters getParameters() {
        return this.parameters;
    }

    public <T> @Nullable T getValue(Parameter parameter) {
        return (T)super.getValue(parameter.getIndex());
    }

    public Object[] getValues() {
        return super.getValues();
    }

    protected Object potentiallyUnwrap(Object parameterValue) {
        return parameterValue;
    }

    public ScoringFunction getScoringFunction() {
        return this.doWithScore(Score::getFunction, Score.class::isInstance, ScoringFunction::unspecified);
    }

    public boolean normalizeSimilarity() {
        return this.doWithScore(it -> true, Similarity.class::isInstance, () -> false);
    }

    public <T> T doWithScore(Function<Score, T> function, Predicate<Score> scoreFilter, Supplier<T> defaultValue) {
        Score score = this.getScore();
        if (score != null && scoreFilter.test(score)) {
            return function.apply(score);
        }
        JpaParameters parameters = this.getParameters();
        if (parameters.hasScoreRangeParameter()) {
            Range range = this.getScoreRange();
            if (range != null && range.getLowerBound().isBounded() && scoreFilter.test((Score)range.getLowerBound().getValue().get())) {
                return function.apply((Score)range.getUpperBound().getValue().get());
            }
            if (range != null && range.getUpperBound().isBounded() && scoreFilter.test((Score)range.getUpperBound().getValue().get())) {
                return function.apply((Score)range.getUpperBound().getValue().get());
            }
        }
        return defaultValue.get();
    }
}

