/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import org.jspecify.annotations.Nullable;
import org.springframework.data.relational.core.dialect.Escaper;
import org.springframework.data.relational.core.query.ValueFunction;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.Assert;

public class EscapingParameterSource
implements SqlParameterSource {
    private final SqlParameterSource parameterSource;
    private final Escaper escaper;

    public EscapingParameterSource(SqlParameterSource parameterSource, Escaper escaper) {
        this.parameterSource = parameterSource;
        this.escaper = escaper;
    }

    public boolean hasValue(String paramName) {
        return this.parameterSource.hasValue(paramName);
    }

    public @Nullable Object getValue(String paramName) throws IllegalArgumentException {
        Object value = this.parameterSource.getValue(paramName);
        if (value instanceof ValueFunction) {
            ValueFunction valueFunction = (ValueFunction)value;
            return valueFunction.apply(this.escaper);
        }
        return value;
    }

    public int getSqlType(String paramName) {
        return this.parameterSource.getSqlType(paramName);
    }

    public @Nullable String getTypeName(String paramName) {
        return this.parameterSource.getTypeName(paramName);
    }

    public String[] getParameterNames() {
        String[] parameterNames = this.parameterSource.getParameterNames();
        Assert.state((parameterNames != null ? 1 : 0) != 0, (String)"Parameter names must not be null");
        return parameterNames;
    }
}

