/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.repository.query.AbstractReactiveElasticsearchRepositoryQuery;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParameterAccessor;
import org.springframework.data.elasticsearch.repository.query.ReactiveElasticsearchQueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;

public class ReactiveElasticsearchStringQuery
extends AbstractReactiveElasticsearchRepositoryQuery {
    private static final Pattern PARAMETER_PLACEHOLDER = Pattern.compile("\\?(\\d+)");
    private final String query;

    public ReactiveElasticsearchStringQuery(ReactiveElasticsearchQueryMethod queryMethod, ReactiveElasticsearchOperations operations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this(queryMethod.getAnnotatedQuery(), queryMethod, operations, expressionParser, evaluationContextProvider);
    }

    public ReactiveElasticsearchStringQuery(String query, ReactiveElasticsearchQueryMethod queryMethod, ReactiveElasticsearchOperations operations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(queryMethod, operations);
        this.query = query;
    }

    @Override
    protected StringQuery createQuery(ElasticsearchParameterAccessor parameterAccessor) {
        String queryString = this.replacePlaceholders(this.query, parameterAccessor);
        return new StringQuery(queryString);
    }

    private String replacePlaceholders(String input, ElasticsearchParameterAccessor accessor) {
        Matcher matcher = PARAMETER_PLACEHOLDER.matcher(input);
        String result = input;
        while (matcher.find()) {
            String placeholder = Pattern.quote(matcher.group()) + "(?!\\d+)";
            int index = (Integer)NumberUtils.parseNumber((String)matcher.group(1), Integer.class);
            result = result.replaceAll(placeholder, this.getParameterWithIndex(accessor, index));
        }
        return result;
    }

    private String getParameterWithIndex(ElasticsearchParameterAccessor accessor, int index) {
        return ObjectUtils.nullSafeToString((Object)accessor.getBindableValue(index));
    }

    @Override
    boolean isCountQuery() {
        return false;
    }

    @Override
    boolean isDeleteQuery() {
        return false;
    }

    @Override
    boolean isExistsQuery() {
        return false;
    }

    @Override
    boolean isLimiting() {
        return false;
    }
}

