/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.document;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.Aggregations;
import org.springframework.data.elasticsearch.core.document.DocumentAdapters;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.util.Assert;

public class SearchDocumentResponse {
    private long totalHits;
    private String totalHitsRelation;
    private float maxScore;
    private final String scrollId;
    private final List<SearchDocument> searchDocuments;
    private final Aggregations aggregations;

    private SearchDocumentResponse(long totalHits, String totalHitsRelation, float maxScore, String scrollId, List<SearchDocument> searchDocuments, Aggregations aggregations) {
        this.totalHits = totalHits;
        this.totalHitsRelation = totalHitsRelation;
        this.maxScore = maxScore;
        this.scrollId = scrollId;
        this.searchDocuments = searchDocuments;
        this.aggregations = aggregations;
    }

    public long getTotalHits() {
        return this.totalHits;
    }

    public String getTotalHitsRelation() {
        return this.totalHitsRelation;
    }

    public float getMaxScore() {
        return this.maxScore;
    }

    public String getScrollId() {
        return this.scrollId;
    }

    public List<SearchDocument> getSearchDocuments() {
        return this.searchDocuments;
    }

    public Aggregations getAggregations() {
        return this.aggregations;
    }

    public static SearchDocumentResponse from(SearchResponse searchResponse) {
        Assert.notNull((Object)searchResponse, (String)"searchResponse must not be null");
        TotalHits responseTotalHits = searchResponse.getHits().getTotalHits();
        long totalHits = responseTotalHits.value;
        String totalHitsRelation = responseTotalHits.relation.name();
        float maxScore = searchResponse.getHits().getMaxScore();
        String scrollId = searchResponse.getScrollId();
        List<SearchDocument> searchDocuments = StreamSupport.stream(searchResponse.getHits().spliterator(), false).filter(Objects::nonNull).map(DocumentAdapters::from).collect(Collectors.toList());
        Aggregations aggregations = searchResponse.getAggregations();
        return new SearchDocumentResponse(totalHits, totalHitsRelation, maxScore, scrollId, searchDocuments, aggregations);
    }
}

