/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.util.Map;
import java.util.function.Supplier;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.repository.aot.generate.RepositoryContributor;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.TypeName;
import org.springframework.util.StringUtils;

class AotRepositoryBeanDefinitionPropertiesDecorator {
    private final Supplier<CodeBlock> inheritedProperties;
    private final RepositoryContributor repositoryContributor;

    public AotRepositoryBeanDefinitionPropertiesDecorator(Supplier<CodeBlock> inheritedProperties, RepositoryContributor repositoryContributor) {
        this.inheritedProperties = inheritedProperties;
        this.repositoryContributor = repositoryContributor;
    }

    public CodeBlock decorate() {
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.add(this.inheritedProperties.get());
        builder.add("beanDefinition.getPropertyValues().addPropertyValue(\"repositoryFragmentsFunction\", new $T() {\n", new Object[]{RepositoryFactoryBeanSupport.RepositoryFragmentsFunction.class});
        builder.indent();
        builder.add("public $T getRepositoryFragments($T beanFactory, $T context) {\n", new Object[]{RepositoryComposition.RepositoryFragments.class, BeanFactory.class, RepositoryFactoryBeanSupport.FragmentCreationContext.class});
        builder.indent();
        for (Map.Entry<String, TypeName> entry : this.repositoryContributor.requiredArgs().entrySet()) {
            if (entry.getValue().equals((Object)TypeName.get(RepositoryFactoryBeanSupport.FragmentCreationContext.class))) {
                if (entry.getKey().equals("context")) continue;
                builder.addStatement("$T $L = context", new Object[]{entry.getValue(), entry.getKey(), entry.getValue()});
                continue;
            }
            builder.addStatement("$T $L = beanFactory.getBean($T.class)", new Object[]{entry.getValue(), entry.getKey(), entry.getValue()});
        }
        builder.addStatement("return RepositoryComposition.RepositoryFragments.just(new $L($L))", new Object[]{this.repositoryContributor.getContributedTypeName(), StringUtils.collectionToDelimitedString(this.repositoryContributor.requiredArgs().keySet(), (String)", ")});
        builder.unindent();
        builder.add("}\n", new Object[0]);
        builder.unindent();
        builder.add("});\n", new Object[0]);
        return builder.build();
    }
}

