/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.io.Serializable;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.domain.Persistable;
import org.springframework.data.repository.core.support.AbstractEntityInformation;

public class PersistableEntityInformation<T extends Persistable<ID>, ID extends Serializable>
extends AbstractEntityInformation<T, ID> {
    private Class<ID> idClass;

    public PersistableEntityInformation(Class<T> domainClass) {
        super(domainClass);
        this.idClass = GenericTypeResolver.resolveTypeArgument(domainClass, Persistable.class);
    }

    @Override
    public boolean isNew(T entity) {
        return entity.isNew();
    }

    @Override
    public ID getId(T entity) {
        return entity.getId();
    }

    @Override
    public Class<ID> getIdType() {
        return this.idClass;
    }
}

