/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.tomcat;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanCustomizer;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.http.HttpServerHandler;
import org.springframework.cloud.sleuth.instrument.web.servlet.HttpServletRequestWrapper;
import org.springframework.cloud.sleuth.instrument.web.servlet.HttpServletResponseWrapper;
import org.springframework.core.log.LogAccessor;
import org.springframework.lang.NonNull;

public class TraceValve
extends ValveBase {
    private static final LogAccessor log = new LogAccessor(TraceValve.class);
    private HttpServerHandler httpServerHandler;
    private CurrentTraceContext currentTraceContext;
    private final ObjectProvider<HttpServerHandler> httpServerHandlerProvider;
    private final ObjectProvider<CurrentTraceContext> currentTraceContextProvider;

    public TraceValve(@NonNull HttpServerHandler httpServerHandler, @NonNull CurrentTraceContext currentTraceContext) {
        this.httpServerHandler = httpServerHandler;
        this.currentTraceContext = currentTraceContext;
        this.httpServerHandlerProvider = null;
        this.currentTraceContextProvider = null;
        this.setAsyncSupported(true);
    }

    public TraceValve(@NonNull ObjectProvider<HttpServerHandler> httpServerHandler, @NonNull ObjectProvider<CurrentTraceContext> currentTraceContext) {
        this.httpServerHandler = null;
        this.currentTraceContext = null;
        this.httpServerHandlerProvider = httpServerHandler;
        this.currentTraceContextProvider = currentTraceContext;
        this.setAsyncSupported(true);
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        Exception ex = null;
        Span handleReceive = this.httpServerHandler().handleReceive(HttpServletRequestWrapper.create(request.getRequest()));
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Created a server receive span [" + handleReceive + "]"));
        }
        request.setAttribute(SpanCustomizer.class.getName(), (Object)handleReceive);
        request.setAttribute(TraceContext.class.getName(), (Object)handleReceive.context());
        request.setAttribute(Span.class.getName(), (Object)handleReceive);
        try (CurrentTraceContext.Scope ws = this.currentTraceContext().maybeScope(handleReceive.context());){
            Valve next = this.getNext();
            if (null == next) {
                return;
            }
            next.invoke(request, response);
        }
        catch (Exception exception) {
            ex = exception;
            throw exception;
        }
        finally {
            this.httpServerHandler().handleSend(HttpServletResponseWrapper.create(request.getRequest(), response.getResponse(), ex), handleReceive);
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Handled send of span [" + handleReceive + "]"));
            }
        }
    }

    private HttpServerHandler httpServerHandler() {
        if (this.httpServerHandler == null) {
            this.httpServerHandler = (HttpServerHandler)this.httpServerHandlerProvider.getIfAvailable();
        }
        return this.httpServerHandler;
    }

    private CurrentTraceContext currentTraceContext() {
        if (this.currentTraceContext == null) {
            this.currentTraceContext = (CurrentTraceContext)this.currentTraceContextProvider.getIfAvailable();
        }
        return this.currentTraceContext;
    }
}

