/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.servlet;

import jakarta.servlet.MultipartConfigElement;
import org.jspecify.annotations.Nullable;
import org.springframework.util.unit.DataSize;

public class MultipartConfigFactory {
    private @Nullable String location;
    private @Nullable DataSize maxFileSize;
    private @Nullable DataSize maxRequestSize;
    private @Nullable DataSize fileSizeThreshold;

    public void setLocation(@Nullable String location) {
        this.location = location;
    }

    public void setMaxFileSize(@Nullable DataSize maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setMaxRequestSize(@Nullable DataSize maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public void setFileSizeThreshold(@Nullable DataSize fileSizeThreshold) {
        this.fileSizeThreshold = fileSizeThreshold;
    }

    public MultipartConfigElement createMultipartConfig() {
        long maxFileSizeBytes = this.convertToBytes(this.maxFileSize, -1);
        long maxRequestSizeBytes = this.convertToBytes(this.maxRequestSize, -1);
        long fileSizeThresholdBytes = this.convertToBytes(this.fileSizeThreshold, 0);
        return new MultipartConfigElement(this.location, maxFileSizeBytes, maxRequestSizeBytes, (int)fileSizeThresholdBytes);
    }

    private long convertToBytes(@Nullable DataSize size, int defaultValue) {
        if (size != null && !size.isNegative()) {
            return size.toBytes();
        }
        return defaultValue;
    }
}

