/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

class DriverClassNameProvider {
    private static final String JDBC_URL_PREFIX = "jdbc";
    private static final Map<String, String> DRIVERS;

    DriverClassNameProvider() {
    }

    String getDriverClassName(String jdbcUrl) {
        Assert.notNull((Object)jdbcUrl, (String)"JdbcUrl must not be null");
        Assert.isTrue((boolean)jdbcUrl.startsWith(JDBC_URL_PREFIX), (String)"JdbcUrl must start with 'jdbc'");
        String urlWithoutPrefix = jdbcUrl.substring(JDBC_URL_PREFIX.length());
        for (Map.Entry<String, String> driver : DRIVERS.entrySet()) {
            if (!urlWithoutPrefix.startsWith(":" + driver.getKey() + ":")) continue;
            return driver.getValue();
        }
        return null;
    }

    static {
        HashMap<String, String> drivers = new HashMap<String, String>();
        drivers.put("derby", "org.apache.derby.jdbc.EmbeddedDriver");
        drivers.put("h2", "org.h2.Driver");
        drivers.put("hsqldb", "org.hsqldb.jdbc.JDBCDriver");
        drivers.put("sqlite", "org.sqlite.JDBC");
        drivers.put("mysql", "com.mysql.jdbc.Driver");
        drivers.put("mariadb", "org.mariadb.jdbc.Driver");
        drivers.put("google", "com.google.appengine.api.rdbms.AppEngineDriver");
        drivers.put("oracle", "oracle.jdbc.OracleDriver");
        drivers.put("postgresql", "org.postgresql.Driver");
        drivers.put("jtds", "net.sourceforge.jtds.jdbc.Driver");
        drivers.put("sqlserver", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
        drivers.put("firebirdsql", "org.firebirdsql.jdbc.FBDriver");
        drivers.put("db2", "com.ibm.db2.jcc.DB2Driver");
        drivers.put("teradata", "com.teradata.jdbc.TeraDriver");
        DRIVERS = Collections.unmodifiableMap(drivers);
    }
}

