/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.measure.internal;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.measure.Measure;
import org.sonar.api.batch.sensor.measure.NewMeasure;
import org.sonar.api.internal.apachecommons.lang.builder.EqualsBuilder;
import org.sonar.api.internal.apachecommons.lang.builder.HashCodeBuilder;
import org.sonar.api.internal.google.common.base.Preconditions;

public class DefaultMeasure<G extends Serializable>
extends DefaultStorable
implements Measure<G>,
NewMeasure<G> {
    private InputComponent component;
    private Metric<G> metric;
    private G value;
    private boolean fromCore = false;

    public DefaultMeasure() {
    }

    public DefaultMeasure(@Nullable SensorStorage storage) {
        super(storage);
    }

    @Override
    public DefaultMeasure<G> on(InputComponent component) {
        Preconditions.checkArgument(component != null, "Component can't be null");
        Preconditions.checkState(this.component == null, "on() already called");
        this.component = component;
        return this;
    }

    @Override
    public DefaultMeasure<G> forMetric(Metric<G> metric) {
        Preconditions.checkState(this.metric == null, "Metric already defined");
        Preconditions.checkNotNull(metric, "metric should be non null");
        this.metric = metric;
        return this;
    }

    @Override
    public DefaultMeasure<G> withValue(G value) {
        Preconditions.checkState(this.value == null, "Measure value already defined");
        Preconditions.checkNotNull(value, "Measure value can't be null");
        this.value = value;
        return this;
    }

    public boolean isFromCore() {
        return this.fromCore;
    }

    public DefaultMeasure<G> setFromCore() {
        this.fromCore = true;
        return this;
    }

    @Override
    public void doSave() {
        Preconditions.checkNotNull(this.value, "Measure value can't be null");
        Preconditions.checkNotNull(this.metric, "Measure metric can't be null");
        Preconditions.checkState(this.metric.valueType().equals(this.value.getClass()), "Measure value should be of type " + this.metric.valueType());
        this.storage.store(this);
    }

    @Override
    public Metric<G> metric() {
        return this.metric;
    }

    @Override
    public InputComponent inputComponent() {
        return this.component;
    }

    @Override
    public G value() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultMeasure rhs = (DefaultMeasure)obj;
        return new EqualsBuilder().append(this.component, rhs.component).append(this.metric, rhs.metric).append(this.value, rhs.value).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(27, 45).append(this.component).append(this.metric).append(this.value).toHashCode();
    }
}

