/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven.bootstrap;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public class PropertyDecryptor {
    private final Log log;
    private final SecDispatcher securityDispatcher;

    public PropertyDecryptor(Log log, SecDispatcher securityDispatcher) {
        this.log = log;
        this.securityDispatcher = securityDispatcher;
    }

    public Map<String, String> decryptProperties(Map<String, String> properties) {
        HashMap<String, String> newProperties = new HashMap<String, String>();
        try {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                if (!entry.getKey().contains(".password") && !entry.getKey().contains(".login")) continue;
                newProperties.put(entry.getKey(), this.decrypt(entry.getKey(), entry.getValue()));
            }
        }
        catch (Exception e) {
            this.log.warn((CharSequence)"Unable to decrypt properties", (Throwable)e);
        }
        return newProperties;
    }

    private String decrypt(String key, String value) {
        try {
            return this.securityDispatcher.decrypt(value);
        }
        catch (SecDispatcherException e) {
            this.log.debug((CharSequence)("Unable to decrypt property " + key), (Throwable)e);
            return value;
        }
    }
}

