/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven.bootstrap;

import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.sonar.runner.api.EmbeddedRunner;
import org.sonar.runner.api.LogOutput;
import org.sonarsource.scanner.maven.bootstrap.PropertyDecryptor;

public class RunnerFactory {
    private final LogOutput logOutput;
    private final RuntimeInformation runtimeInformation;
    private final MavenSession session;
    private final boolean debugEnabled;
    private PropertyDecryptor propertyDecryptor;

    public RunnerFactory(LogOutput logOutput, boolean debugEnabled, RuntimeInformation runtimeInformation, MavenSession session, PropertyDecryptor propertyDecryptor) {
        this.logOutput = logOutput;
        this.runtimeInformation = runtimeInformation;
        this.session = session;
        this.debugEnabled = debugEnabled;
        this.propertyDecryptor = propertyDecryptor;
    }

    public EmbeddedRunner create() {
        EmbeddedRunner runner = EmbeddedRunner.create((LogOutput)this.logOutput);
        runner.setApp("Maven", this.runtimeInformation.getApplicationVersion().toString());
        runner.addGlobalProperties(this.createGlobalProperties());
        runner.setGlobalProperty("sonar.mojoUseRunner", "true");
        if (this.debugEnabled) {
            runner.setGlobalProperty("sonar.verbose", "true");
        }
        return runner;
    }

    private Properties createGlobalProperties() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.session.getCurrentProject().getProperties());
        p.putAll((Map<?, ?>)this.session.getExecutionProperties());
        p.putAll((Map<?, ?>)this.propertyDecryptor.decryptProperties(p));
        return p;
    }
}

