/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.lift;

import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.lift.TestContext;
import org.openqa.selenium.lift.find.Finder;
import org.openqa.selenium.lift.match.NumericalMatchers;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.SystemClock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDriverTestContext
implements TestContext {
    private WebDriver driver;
    private final Clock clock;

    public WebDriverTestContext(WebDriver driver) {
        this(driver, new SystemClock());
    }

    WebDriverTestContext(WebDriver driver, Clock clock) {
        this.driver = driver;
        this.clock = clock;
    }

    @Override
    public void quit() {
        this.driver.quit();
    }

    @Override
    public void goTo(String url) {
        this.driver.get(url);
    }

    @Override
    public void assertPresenceOf(Finder<WebElement, WebDriver> finder) {
        this.assertPresenceOf(NumericalMatchers.atLeast(1), finder);
    }

    @Override
    public void assertPresenceOf(Matcher<Integer> cardinalityConstraint, Finder<WebElement, WebDriver> finder) {
        Collection<WebElement> foundElements = finder.findFrom(this.driver);
        if (!cardinalityConstraint.matches((Object)foundElements.size())) {
            StringDescription description = new StringDescription();
            description.appendText("\nExpected: ").appendDescriptionOf(cardinalityConstraint).appendText(" ").appendDescriptionOf(finder).appendText("\n     got: ").appendValue((Object)foundElements.size()).appendText(" ").appendDescriptionOf(finder).appendText("\n");
            this.failWith(description.toString());
        }
    }

    @Override
    public void type(String input, Finder<WebElement, WebDriver> finder) {
        WebElement element = this.findOneElementTo("type into", finder);
        element.sendKeys(new CharSequence[]{input});
    }

    @Override
    public void clickOn(Finder<WebElement, WebDriver> finder) {
        WebElement element = this.findOneElementTo("click on", finder);
        element.click();
    }

    public void clickOnFirst(Finder<WebElement, WebDriver> finder) {
        WebElement element = this.findFirstElementTo("click on", finder);
        element.click();
    }

    private WebElement findFirstElementTo(String action, Finder<WebElement, WebDriver> finder) {
        Collection<WebElement> foundElements = finder.findFrom(this.driver);
        if (foundElements.isEmpty()) {
            this.failWith("could not find element to " + action);
        }
        return foundElements.iterator().next();
    }

    private WebElement findOneElementTo(String action, Finder<WebElement, WebDriver> finder) {
        Collection<WebElement> foundElements = finder.findFrom(this.driver);
        if (foundElements.isEmpty()) {
            this.failWith("could not find element to " + action);
        } else if (foundElements.size() > 1) {
            this.failWith("did not know what to " + action + " - ambiguous");
        }
        return foundElements.iterator().next();
    }

    private void failWith(String message) throws AssertionError {
        throw new AssertionError((Object)message);
    }

    @Override
    public void waitFor(Finder<WebElement, WebDriver> finder, long timeoutMillis) {
        long timeoutTime = this.clock.now() + timeoutMillis;
        while (this.clock.now() < timeoutTime) {
            Collection<WebElement> result = finder.findFrom(this.driver);
            for (WebElement webElement : result) {
                if (!((RenderedWebElement)webElement).isDisplayed()) continue;
                return;
            }
        }
        this.failWith("Element was not rendered within " + timeoutMillis + "ms");
    }
}

